function aCompartment = Compartment(varargin)
% Compartment class constructor
%**************************************************************************
%
% $Id: Compartment.m,v 1.1 2004/11/04 20:13:39 bhendrik Exp $
% $Revision: 1.1 $
% $Author: bhendrik $
% $Date: 2004/11/04 20:13:39 $
% Type: Matlab script.
%
% Comments: 
%
% Written by Bart Hendriks
%
%**************************************************************************


switch nargin
    case 0  
        structCompartment = struct('Name', {}, ...
            'Number', {} , ...
            'Size', {} , ...
            'Units', {} , ...
            'Outside', {}, ...
            'Description', {} , ...
            'Reference',  {} ...
             );
        structCompartment(1).Name = 'Empty Compartment';  
        aCompartment = class(structCompartment,'Compartment');
    case 1  
        if isa(varargin{1},'Compartment')
            aCompartment = varargin{1};
        elseif isa(varargin{1},'struct')
            CompartmentInput = varargin{1};
            
            aCompartment = Compartment;
            aCompartment = set(aCompartment, ...
                'Name', CompartmentInput(1).Name , ...
                'Number', CompartmentInput(1).Number , ...
                'Size', CompartmentInput(1).Size , ...
                'Units', CompartmentInput(1).Units , ...
                'Outside', CompartmentInput(1).Outside , ...
                'Description',  CompartmentInput(1).Description , ...
                'Reference', CompartmentInput(1).Reference ...
                );
        else
            error(['Argument to Compartment is of class',class(varargin{1})]);
        end;
    otherwise   
        error('Cannot initialize');
end;

return;

