library(BatchExperiments)
library(EpiGLM)

data(staticData)

rm(reg)
system("rm -r estBoot-files")

reg <- makeExperimentRegistry(id="estBoot",
                              packages=c("EpiGLM", "plyr"))
repls <- 10

nn <- Sys.info()["nodename"]
if (nn == "phylocluster.ccbb.utexas.edu"){
  resources <- list(queue="wilke")
  chunk.size <- 500
} else {
  resources <- list()
  chunk.size <- 1
}

addProblem(reg, id="prob", static=xx4, dynamic=get_data_wrapper2)

prob.design <- makeDesign("prob", exhaustive=list(floor_times=TRUE, nreps=1,
                                    mode="sim", maxinftime="limit2"))

addAlgorithm(reg, id="est", fun=get_est)
alg.design <- makeDesign("est", exhaustive=list(gr_intercept="yes",
                                  gr_terms="set1", altfits=FALSE,
                                  limit_staff_to_one_day=TRUE))

addExperiments(reg, prob.designs=prob.design,
               algo.designs=alg.design, repls=repls)

summarizeExperiments(reg)
chunks <- chunk(findExperiments(reg), chunk.size=chunk.size)
submitJobs(reg, ids=chunks, resources=resources)
showStatus(reg)

save.image(file="estBoot.RData")
q('no')
