#include <admodel.h>

  extern "C"  {
    void ad_boundf(int i);
  }
#include <epiglm-log.htp>

model_data::model_data(int argc,char * argv[]) : ad_comm(argc,argv)
{
  n.allocate("n");
  pgr.allocate("pgr");
  ptr.allocate("ptr");
  sumh.allocate(1,n,"sumh");
  tau.allocate(1,n,"tau");
  k.allocate(1,n,"k");
  Zgr.allocate(1,n,1,pgr,"Zgr");
  Ztr.allocate(1,n,1,ptr,"Ztr");
  Y.allocate(1,n,1,k,"Y");
}

model_parameters::model_parameters(int sz,int argc,char * argv[]) : 
 model_data(argc,argv) , function_minimizer(sz)
{
  initializationfunction();
  ctr.allocate(1,ptr,-10,10,"ctr");
  cgr.allocate(1,pgr,-10,10,"cgr");
  pop_vec.allocate(1,n,"pop_vec");
  #ifndef NO_AD_INITIALIZE
    pop_vec.initialize();
  #endif
  betavec.allocate(1,n,"betavec");
  #ifndef NO_AD_INITIALIZE
    betavec.initialize();
  #endif
  survivorvec.allocate(1,n,"survivorvec");
  #ifndef NO_AD_INITIALIZE
    survivorvec.initialize();
  #endif
  incidence_vec.allocate(1,n,"incidence_vec");
  #ifndef NO_AD_INITIALIZE
    incidence_vec.initialize();
  #endif
  f.allocate("f");
}

void model_parameters::userfunction(void)
{
  dvariable fpen = 0.0; //penalty variable
  incidence_vec = mfexp(Zgr * cgr);
  betavec = mfexp(Ztr * ctr);
  pop_vec = elem_div(incidence_vec, betavec);
  for (int i=1; i <=n; i++)
  {
    survivorvec(i) = pop_vec(i) - k(i);
    survivorvec(i) = posfun(survivorvec(i),0.001,fpen);
    betavec(i) = posfun(betavec(i),0.000001,fpen);
  }
  // negative log-likelihood
  f = 0.0;
  f += 1000 * fpen;
  for (int i=1; i<=n; i++)
  {
    f -= gammln(survivorvec(i) + k(i) + 1) - gammln(survivorvec(i) + 1);
    if (k(i) >= 1)
    {
      f -= -betavec(i) * sumh(i);
      for (int j=1; j <= k(i); j++)
      {
        f -= log(betavec(i) * Y(i,j));
      }
    }
    f -= survivorvec(i) * -betavec(i) * tau(i);
  }
}

void model_parameters::preliminary_calculations(void){
  admaster_slave_variable_interface(*this);
}

model_data::~model_data()
{}

model_parameters::~model_parameters()
{}

void model_parameters::report(void){}

void model_parameters::final_calcs(void){}

void model_parameters::set_runtime(void){}

#ifdef _BORLANDC_
  extern unsigned _stklen=10000U;
#endif


#ifdef __ZTC__
  extern unsigned int _stack=10000U;
#endif

  long int arrmblsize=0;

int main(int argc,char * argv[])
{
    ad_set_new_handler();
  ad_exit=&ad_boundf;
  arrmblsize = 40000000L;
  gradient_structure::set_GRADSTACK_BUFFER_SIZE(3000000);
  gradient_structure::set_CMPDIF_BUFFER_SIZE(200000);
  gradient_structure::set_MAX_NVAR_OFFSET(460404);
    gradient_structure::set_NO_DERIVATIVES();
    gradient_structure::set_YES_SAVE_VARIABLES_VALUES();
  #if defined(__GNUDOS__) || defined(DOS386) || defined(__DPMI32__)  || \
     defined(__MSVC32__)
      if (!arrmblsize) arrmblsize=150000;
  #else
      if (!arrmblsize) arrmblsize=25000;
  #endif
    model_parameters mp(arrmblsize,argc,argv);
    mp.iprint=10;
    mp.preliminary_calculations();
    mp.computations(argc,argv);
    return 0;
}

extern "C"  {
  void ad_boundf(int i)
  {
    /* so we can stop here */
    exit(i);
  }
}
