# rm(list=ls())
setwd('~/Desktop/mcg_power_analysis/')

source('power_analysis_functions.R')


# some useful values determined via simluation
# actual delta
deltas <-  c(.0945, .1725, .33, .5)

# rounded population effect caused by above deltas
delta_to_pop_round <- c(5, 10, 20, 30)/100


# fill out the list with the parameters of your study
simulation_parameters <- list(
    N=100,
    n_stimuli=3,
    n_trials=10,

    # only group_type unpaired is currently implemented
    group_type='unpaired',

    # delta here is the absolute shift applied to the data. This is larger than the actual
    # population difference because of truncation. see delta_to_pop_round above
    delta=function(pF) pF + deltas[2],

    # control truncation here
    limit=function(pF) clip(pF, limits = c(0.05, 0.95))
)

sim_res <- do_sim(simulation_parameters, chunk_size = 10, n.rep=10)
sim_res.analyzed <- analyze_sim_results(sim_res)


# put the results into a csv file for long-term storage
write.csv(sim_res.analyzed, file='my_power.csv', row.names=F)
