# helper functions nchoosek and factorial for the gillespie
# implementation.
#
# lawrence david, 2006. ldavid@mit.edu

# populate dictionaries from input file
def ReadInputFile(input_filename):

    substrate_dict = {}
    product_dict = {}
    c_dict = {}

    input_file = open(input_filename,"r")

    line_count = 0
    cur_rxn = None
    
    for line in input_file:
        this_line = line.strip()
        spot = line_count % 5

        args = this_line.split()

        if len(args) < 1:
            line_count += 1
            continue

        ltyp = args[0]
        rem = args[1:]

        if ltyp == "Rxn":
            cur_rxn = rem[0]
        elif ltyp == "Subs":
            substrate_dict[cur_rxn] = {}
            for species in rem:
                if species in substrate_dict[cur_rxn]:
                    substrate_dict[cur_rxn][species] += 1
                else:
                    substrate_dict[cur_rxn][species] = 1
        elif ltyp == "Prods":
            product_dict[cur_rxn] = {}
            for species in rem:
                if species in product_dict[cur_rxn]:
                    product_dict[cur_rxn][species] += 1
                else:
                    product_dict[cur_rxn][species] = 1
        elif ltyp == "Rate":
            c_dict[cur_rxn] = float(rem[0])

        # will ignore spaces
        line_count += 1

    return substrate_dict, product_dict, c_dict

# load in species abundances
def ReadCountsFile(input_filename):

    counts_dict = {}

    input_file = open(input_filename,"r")

    for line in input_file:
        this_line = line.strip().split()
        if len(this_line) > 0:
            counts_dict[this_line[0]] = int(this_line[1])

    return counts_dict

# perform a choose
def NChooseK(n,k):

    if k > n:
        return 0 

    # pre-load easy-case results for running-time speed-up
    if k == 0:
        return 1
    if k == 1:
        return n
    if k == 2:
        return n*(n-1)/2
    if k == 3:
        return n*(n-1)*(n-2)/6
    if k == 4:
        return n*(n-1)*(n-2)*(n-3)/24

    # use factorials (this is slow though!) if not an easy case
    return Factorial(n)/(Factorial(k)*Factorial(n-k))

# take a factorial
def Factorial(n):
    if n == 1:
        return n
    return n*Factorial(n-1)


