#
# Constants used for example predictions
#


# Prior probability of a common cause, set to 0.5
# could be different depending on person/context
Pcommon = 0.5

# these determine the plotting regions
X_LIM = c(-5, 17)
Y_LIM = c(-5, 17)

# dimension of the space is 2
n.dim = 2

# Locations for words in representational space.
ba = c(0, 12)
da = c(5, 5)
ga = c(12, 0)
syllables.locations = rbind(ba, da, ga)
n.syllables = nrow(syllables.locations)

# Exemplar generating distributions, make them all equal for now
ba.sds = rep(1, n.dim)

da.sds = ba.sds
ga.sds = ba.sds
category.sds = cbind(ba.sds, da.sds, ga.sds)

# capital S Sigmas are the variances
category.Sigmas = lapply(seq_len(n.syllables), function(ii) diag(category.sds[, ii]^2))

# Exemplar encoding distributions
# In other places we rely on these being 0-covariance
# don't change the off-diagonal with checking for instances of 1/Sa and 1/Sv
# Values here produce a 1.5:1 ratio in SD scale
Sa = diag(c(2, 4.5))
Sv = diag(c(4.5, 2))

# Precalculate the inverses and Sav
invSa = solve(Sa)
invSv = solve(Sv)
Sav = solve(invSa + invSv)

# Prior on syllables is assumed to be flat
# this could be changed to reflect things like P(da) > P(ga)
syllables.priors = rep(1/n.syllables, n.syllables)
