#
# Model description figures for Magnotti & Beauchamp, PLOS CB, 2017
#

# clear out current workspace
rm(list=ls())


#
# libraries that may need to be installed
# install.packages('mvtnorm')
# isntall.packages('RColorBrewer')


# navigate to the code directory
setwd("~/Desktop/cims_mcg_code_pack/")

# changing values in the constants file will produce different predicted levels
source("mcgurk_causal_inference_constants.R")
source("mcgurk_causal_inference_functions.R")
source("mcgurk_causal_inference_plotters.R")



# pre-calculate classification and causal inference images
# set the resolution to be the smallest needed, check output in figures/ for blockiness
# assumes 1.15 inch image
classification.img <- draw.classification_overlay(render=FALSE, res = 600*1.15)

pc1.img <- draw.pc1_overlay(render=FALSE, res = 600*1.15)

# save out the image if you calculated it at a high res and don't want to repeat the process
#save(classification.img, file = 'classification.img.RData')
#save(pc1.img, file = 'pc1.img.RData')

# load already calculated images -- these are specific to values in the *_constants.R file
#load('classification.img.RData')
#load('pc1.img.RData')

# write out the color bar
make.pc1_colorbar()

#
#	Figure 1
#
# Panel A is causal inference pictures

# Panel B: representational space with colored syllable space
make.content_plot('representational_space_with_boundaries', {
    draw.classification_overlay(z=classification.img)
})

# Panels C through F are model steps and predictions for AbaVga
# this function calls several plotting functions, writes out figures, and prints out predicted perception
plot.non_cims_model(prefx = 'mcg', A=ba, V=ga)

# Panel G is behavioral data, made later; see data/ for more

#Panels H-K are model steps and predictions for AgaVba
plot.non_cims_model('non_mcg', A=ga, V=ba)

# Figure 2

# A - E
# CIMS model steps/predictions for McGurk stimulus
# this can take a few minutes
plot.cims_model('mcg', ba, ga)

# G - K
# are CIMS model steps/predictions for non-McGurk stimulus
# this can take a few minutes
plot.cims_model('non_mcg', ga, ba)

## Runs analyze_recombine_bgd.R to obtain `fc.mean` variable
source('data/analyze_recombine_bgd.R')

# compare with mTurk data
# these will go into Figures 1 and 2 in the right place
make.barplot('mcg_mTurk', fc.mean[3,3:5])
make.barplot('non_mcg_mTurk', fc.mean[7,3:5])


##
# compare models on other syllable combinations
##
pred_no_cims = function(A,V,n=10000) {
    tabulate(apply(get_encoded_exemplar(A, V, samples=n)$av, 1, classify_sample), nbins=n.syllables) / n
}

pred_cims = function(A,V, n=10000) {
    mS = get_ci_mean_Sigma(A, V, n)
    tabulate(apply(mS$xav, 1, classify_sample), nbins=3) / nrow(mS$xav)
}

sylls = list("ba"=ba, "da"=da, "ga"=ga)

get_all_pred = function(PRED_FUN) {
    lapply(sylls, function(A) {
        t(sapply(sylls, function(V) {
            PRED_FUN(A,V)
        }))
    })
}

# these calls can take a few minutes
no_cims_pred = do.call(rbind, get_all_pred(pred_no_cims))
cims_pred = do.call(rbind, get_all_pred(pred_cims))

# builds confusion matrices for congruent and incongruent stimuli
make.confusion_mat(mat=fc.mean[,3:5], fname='fc.beh')
make.confusion_mat(cims_pred, fname='cims_pred')
make.confusion_mat(no_cims_pred, fname='non_cims_pred')

cor(c(fc.mean[,3:5]), c(cims_pred))
cor(c(fc.mean[,3:5]), c(no_cims_pred))

cong = c(1, 5, 9)
inc = (1:9)[-cong]

length(inc)
cor.test(c(fc.mean[inc,3:5]), c(no_cims_pred[inc,]))
cor.test(c(fc.mean[inc,3:5]), c(cims_pred[inc,]))

cor.test(c(fc.mean[cong,3:5]), c(no_cims_pred[cong,]))
cor.test(c(fc.mean[cong,3:5]), c(cims_pred[cong,]))

#confusion mat color bar
make.cmat_colorbar()
