#
# Functions that help when drawing multidimensional, potentially unequal variance Gaussians (ellipses)
#
sigma.mat = function(s) {
	d = sqrt(length(s))
	return(array(s, c(d, d)))
}

ellipse = function(m, s, N = 100, sd = 1) {
	L = chol(s)
	t = seq(0, 2 * pi, length.out = N)
	XY = cbind(cos(t), sin(t))
	ell = sd * XY %*% L

	ell = t(ell) + m

	return(t(ell))
}

fill.ellipse = function(m, s, idx=1:2, col='black', sd = 2, alpha = 100, lwd = 3, lty=1, border.col='black') {
	ell = ellipse(m[idx], s[idx, idx], sd = sd)
	polygon(ell[-nrow(ell), ], lwd = lwd, border = border.col, col = getAlphaRGB(col, alpha), lty=lty)
}

# draw an ellipse with a black/white "dashed" outline apperance
# check out 'lend' values to change look/feel
dashed.ellipse = function(mean, S, stdev=1, seg.len=50, lwd=1, N=1000) {
	ell = ellipse(mean, S, N=N, sd=stdev)

	onOff = rep(rep(c(T,F), each=seg.len), len=nrow(ell))

	ell.black = ell
	ell.black[onOff] = NA

	ell.white = ell
	ell.white[!onOff] = NA

	lines(ell.black[,1], ell.black[,2], col='black', lwd=lwd)
	lines(ell.white[,1], ell.white[,2], col='white', lwd=lwd, lend=1)
}
