library(stringr)

fc = read.csv('data/Batch_2483023_batch_results.csv', stringsAsFactors=FALSE)

print("GENDER")
print(table(fc$Answer.gender))
print("AGE")
print(sum(table(fc$Answer.ageRange)[1:5] * c(21.5, 30.5,40.5,50.5,60.5)) / 59)

syllable_to_number = function(syll) {
    which(tolower(substr(syll, 1, 1)) == c('b', 'd', 'g'))
}

number_to_syllable = function(n) {
    if(n<1) n = n*10
    c('ba', 'da', 'ga')[as.integer(n)]
}

convert_response_vector = function(resp) {
    c(as.numeric(resp[1]),
      syllable_to_number(substr(resp[2], 10, 10)),
      syllable_to_number(substr(resp[2], 12, 12)),
      syllable_to_number(resp[3]))
}

one_row_per_trial = function(subj, n.trials=90) {
    vars = paste0('Answer.', c('Trial_', 'stimulus_', 'Response_'))

    subj.flat = t(sapply(seq(n.trials), function(ii) {
        convert_response_vector(sapply(paste0(vars, ii), getElement, obj=subj))
    }))

    colnames(subj.flat) = c('Trial', 'A', 'V', 'Response')

    return (subj.flat)
}

process_subject = function(subj) {
    subj.flat = one_row_per_trial(subj)
    aggregate(subj.flat[,'Response'], list(subj.flat[,'V'], subj.flat[,'A']), tabulate, nbins=3) / 10
}

fc.subj = apply(fc, 1, process_subject)

getRow = function(m, rI, cI) as.matrix(m)[rI, cI]

mean_across_list_of_matrices = function(ll, colIdx=3:5) {
    res = matrix(NA, nrow(ll[[1]]), length(colIdx))

    for(ii in 1:nrow(res)) {
        res[ii,] = rowMeans(sapply(ll, getRow, ii, colIdx))
    }
return(res)
}

fc.mean = mean_across_list_of_matrices(fc.subj, 1:5)

# explore the data a bit
if(FALSE) {
    clrs = c('orange', 'dodgerblue3', 'darkgreen')
    dev.new()
    par(mfrow=c(3,3))
    for(ii in 1:9){
        barplot(fc.mean[ii,3:5], ylim=c(0,1), las=1,
            col=clrs,
            border=FALSE, main=paste0('A', number_to_syllable(fc.subj[[1]][ii,2]), 'V', number_to_syllable(fc.subj[[1]][ii,1])), names.arg=c('ba', 'da', 'ga'), cex.names = 2, cex.axis = 1.5)
    }

    #just check the congruents per subject
    plot_subj_congruent = function(sbj) {
        y = mapply(function(x,y) sbj[x,y], c(1,5,9), 3:5)
        barplot(y, col=clrs, ylim=0:1)
        return(mean(y))
    }
    dev.new()
    par(mfrow=c(10,6), mar=rep(1,4))
    cong.subj = sapply(fc.subj, plot_subj_congruent)

    print(mean(cong.subj))
}

