#! /usr/local/bin/python

import sys, os, math, string, random
sys.path = [os.path.expanduser('~/research/lib')] + sys.path
import translate

class MuscleError(Exception):
	"""MUSCLE alignment error"""

def alignSequencesWithHeader(seq_list, max_iters=16, exepath="./muscle"):
	tmp_fasta_file = "tmp%d.txt" % random.randint(0,100000)
	tmpfile = file(tmp_fasta_file, 'w')
	for (hdr, seq) in seq_list:
		tmpfile.write('>%s\n%s\n' % (hdr, seq))
	tmpfile.close()

	outfile_name = "tmp-muscle-out-%d.txt" % random.randint(0,100000)

	cmd = "muscle -in %s -out %s -quiet -stable -maxiters %d" % (tmp_fasta_file, outfile_name, max_iters)
	#print cmd
	error = os.spawnv(os.P_WAIT, os.path.expanduser(exepath), [x for x in cmd.split()])
	if not error:
		seq_dict = translate.Read_FASTA_Dict(outfile_name)
		os.remove(outfile_name)
		os.remove(tmp_fasta_file)
		return seq_dict.items()
	else:
		raise MuscleError, "Muscle error code %d" % error

def alignSequences(seq_list, max_iters=16, exepath="./muscle"):
	tmp_fasta_file = "tmp%d.txt" % random.randint(0,100000)
	full_tmp_fasta_file = tmp_fasta_file #os.path.join(os.getcwd(),tmp_fasta_file)
	tmpfile = file(tmp_fasta_file, 'w')
	#tmpfile = file(full_tmp_fasta_file, 'w')
	i = 0
	for seq in seq_list:
		tmpfile.write('>%d\n%s\n' % (i, seq))
		i += 1
	tmpfile.close()

	outfile_name = os.path.join(os.getcwd(),"tmp-muscle-out-%d.txt" % random.randint(0,100000))

	cmd = "muscle -in %s -out %s -quiet -stable -maxiters %d" % (full_tmp_fasta_file, outfile_name, max_iters)
	#print cmd
	error = os.spawnv(os.P_WAIT, os.path.expanduser(exepath), [x for x in cmd.split()])

	if not error:
		(hdrs, seqs) = translate.Read_FASTA(outfile_name)
		os.remove(outfile_name)
		os.remove(full_tmp_fasta_file)
		return seqs
	else:
		raise MuscleError, "Muscle error code %d" % error

def alignGeneFromProtein(gene, prot_align):
	j = 0
	gene_align = []
	for i in range(len(prot_align)):
		if prot_align[i] == '-':
			gene_align.append('---')
		else:
			gene_align.append(gene[j : 3 + j])
			j += 3
	return ''.join(gene_align)
