function [MSD1,TauVector,MSDnm,SamplingFreq] = findMSD(EntireMtx)

Size = length(EntireMtx);
SamplingFreq = 1;
TauVector = [[1:1:19] double(int32(logspace(log10(20),log10(Size), 46)))];
% and make sure that length (TauVector) is a power of 2 for Matlab
L = length(TauVector); PowerStop = floor(log2(L)); clear L
TauVector = TauVector (1, 1:2^PowerStop); L = length (TauVector);
% 'TauVector created.'

% Initialization
SquaredX = zeros (Size, L); SquaredY = zeros (Size, L); 
SquaredDisplacement = zeros (Size, L);
MSD = zeros (1, L); 
MSDnm = zeros (1, L);  
MSDum = zeros (1, L);
MSDtoSave = zeros (1,L);
'Matrices initialized.'

for i = 1 : L
    Tau = TauVector (1,i);
    for j = 1 : Size - Tau
        SquaredX (j,i) = (EntireMtx(j,1) - EntireMtx(j + Tau,1)).^2;
        SquaredY (j,i) = (EntireMtx(j,2) - EntireMtx(j + Tau,2)).^2;
        SquaredDisplacement (j,i) = SquaredX (j,i) + SquaredY (j,i); % in um^2.
    end
    MSD(1, i) = 1e-12 * mean (real(SquaredDisplacement(1 : Size - Tau, i))); % in m^2.
end
MSDnm (1,:) = 1e18 .* MSD(1,:); % in nm^2       
'MSD computed.'

MSDtoSave (2,:) = MSDnm (1,:);
MSDtoSave (1,:) = TauVector (1,:) ./ SamplingFreq;
MSD1 = [MSDtoSave(1,:) ; MSDtoSave(2,:)];
