close all;
clear all;
moviefile = 'stabilitytest.avi';
seconds = 180;
fps = 30;
resolution = 138.889; % nm/pixel

vector44 = zeros(seconds-1,2);
vector88 = zeros(seconds-1,2);

for index=2:seconds-1
    temp44x = 0;
    temp44y = 0;
    temp88x = 0;
    temp88y = 0;
    for index2=index*fps:(index+1)*fps
        [t44x,t44y] = tracker(moviefile,index2);
        temp44x = temp44x + t44x;
        temp44y = temp44y + t44y;
        [t88x,t88y] = tracker2(moviefile,index2);
        temp88x = temp88x + t88x;
        temp88y = temp88y + t88y;
    end
    vector44(index,:) = [temp44x/fps, temp44y/fps];
    vector88(index,:) = [temp88x/fps, temp88y/fps];
end

vector44 = vector44(2:end,:);
vector88 = vector88(2:end,:);

r1 = diff(vector44);
r2 = diff(vector88);
r2_1 = r1.^2;
r2_2 = r2.^2;
MSD1x = sum(r2_1(:,1))/length(r2_1(:,1));
MSD1y = sum(r2_1(:,2))/length(r2_1(:,2));
% MSD2 = sum(r2_2)/length(r2_2);
MSD2x = sum(r2_2(:,1))/length(r2_2(:,1));
MSD2y = sum(r2_2(:,2))/length(r2_2(:,2));
convMSD1x = MSD1x*resolution^2;
convMSD1y = MSD1y*resolution^2;
convMDS2x = MSD2x*resolution^2;
convMDS2y = MSD2y*resolution^2;
