close all;
Marker = 'o-';
moviefile = 'Z:\athena.mit.edu\user\s\o\sophia2\Public\20309\cytoD10004';
seconds = 30;
fps = 30;
resolution = 138.889; % nm/pixel
xbox = [202 220];
ybox = [206 225];

% find trajectories
EntireMtx = findTraj(moviefile,seconds,fps,resolution,xbox,ybox);
% find MSD
[MSD1,TauVector,MSDnm,SamplingFreq] = findMSD(EntireMtx);
[Gstar_Record,Gp_Record,Gpp_Record,OmegaVector,GpMason,GppMason,Alpha] = findGstar(MSDnm,TauVector);

figure(1)
loglog (TauVector ./ SamplingFreq, MSDnm, 'o-');
title (['Mean squared displacement - ', moviefile]); ylabel ('MSD (nm^2)'); xlabel ('Tau (s)');

figure(2)
plot(EntireMtx(:,1), EntireMtx(:,2),'o-')  
title(' Endocytosed Bead Position Tracking ')
xlabel(' X position [\mum] ')
ylabel(' Y position [\mum] ')

figure(3)
semilogx(OmegaVector, GpMason, Marker)
title(' Storage Modulus G prime ');
xlabel('\omega'); ylabel('pascals');

figure(4)
loglog(OmegaVector, GppMason, Marker)
title(' Loss Modulus G double prime ');
xlabel('\omega'); ylabel('pascals');

if(1) 
   figure(5)
   loglog(TauVector, MSDnm,'o-');
   xlabel('\tau'); ylabel('MSD [nm^2]'); title('MSD');
end

figure(6)
semilogx( OmegaVector(1,:), Alpha(1,:),'o-'  )
xlabel('\omega'); ylabel('\alpha'); title('\alpha vs \omega');