library(parallel)

# go to the directory containing the code+data
setwd('~/Desktop/mcg_code_pack')
source('mcg_model_functions.R')

# Load the data. It is assumed that the data are in the same directory as the code files
mcg_data = read.csv(file='data.csv', row.names=NULL)

# Functions in mcg_model_functions.R are expecting this variable
cl = makeCluster(detectCores())

# Fit the model
# For 20 subjects with 14 stimuli, this takes about 12s per repetition
mcg_model = optim.mcg(mcg_data, n.sim=5, n.iter=8)

## Model Parameters
disparities = mcg_model$disparities

thresholds	= clip(sapply(mcg_model$subjs, getElement, 'threshold'), range=THRESHOLD_RANGE)

noises	= clip(sapply(mcg_model$subjs, getElement, 'sd'), range=SENSORY_NOISE_RANGE)

# Model Fit Statistics
rmses = sapply(mcg_model$subjs, getElement, 'rmse')

# Predicted Susceptibility Values
fitted = t(sapply(mcg_model$subjs, predict, disparities))

pF.mean.pred = rowMeans(fitted)

pF.mean = colMeans(sapply(mcg_model$subjs, getElement, 'y'))
