########Common plotting helpers########
source('basic_helper.R')

###Ebar functions
ebars = function(x, y, sem, length = 0.05, ...) {
	ebars.y(x, y, sem, length, ...)
}

ebars.x = function(x, y, sem, length = 0.05, ...) {
	arrows(x - sem, y, x + sem, y, angle = 90, code = 3, length = length, ...)
}

ebars.y = function(x, y, sem, length = 0.05, up = T, down = T, code = 2, ...) {
	if (up) {
		arrows(x0 = x, y0 = as.numeric(y), y1 = as.numeric(y + sem), angle = 90, code = code, length = length, ...)
	}
	if (down) {
		arrows(x0 = x, y0 = as.numeric(y), y1 = as.numeric(y - sem), angle = 90, code = code, length = length, ...)
	}
}

ebar_polygon = function(x, y, sem, col, border = NA) {
	polygon(c(x, rev(x)), c(y + sem, rev(y - sem)), border = border, col = col)
}

# clean barplot with no x axis
simpleBars = function(heights, col = c("blue", "darkgreen", "gray", "black"), ...) {
	barplot(heights, col = col, border = NA, axes = F, axisnames = F, ...)
	axis(2, labels = F, at = c(0, 0.5 * max(heights), max(heights)))
}

# the idea is to wrap any ole plot function with one a function that adds error bars
# we have to special case barplot
# right now this function only support y-axis error bars
with_error_bars = function(plot_func) {

	return(function(x, y = NULL, sem, col = "black", down = T, up = T, ...) {
		## special case for barplot here
		if (body(plot_func) == body(barplot)) {
			x = plot_func(y, col = col, border = NA, ...)
			down = F
		} else {
			if (is.na(x)) {
				x = 1:length(y)
			}
			plot_func(x, y, col = col, ...)
		}

		ebars.y(x, y, sem, up = up, down = down, col = col)

		return(invisible(x))
	})
}

#Plots line with error bars, each column is point
ebar_plot = function(x=1:ncol(mat), mat, overlay = F, type = "o", lwd = 3, col = "black", ebar.lwd = (lwd - 1), code = 2, SUMM = m_sem, 
	...) {
	summ = SUMM(mat)

	if (overlay == F) {
		plot(x, summ[, 1], type = type, lwd = lwd, col = col, ...)
	} else {
		lines(x, summ[, 1], type = type, lwd = lwd, col = col, ...)
	}

	ebars.y(x, summ[, 1], summ[, 2], lwd = ebar.lwd, col = col, code = code)

	invisible(summ)
}


plotManyLines = function(x = 1:ncol(mat), mat, col = "black", ylim = NA, ...) {
	if (is.na(ylim)) {
		ylim = range(c(mat))
	}
	plot(x, mat[1, ], type = "n", ...)
	for (i in 1:nrow(mat)) lines(x, mat[i, ], col = col)
}

getAlphaRGB = function(colname, alpha) {
	c = col2rgb(colname)
	rgb(t(c), alpha = alpha, maxColorValue = 255)
}

poly = function(x, lower, upper, col = "gray", ...) {
	lower = rep(lower, length.out = length(x))
	upper = rep(upper, length.out = length(x))
	polygon(c(x, rev(x)), c(upper, rev(lower)), col = col, ...)
}

bplot = function(x, heights, sems, width, col = rep("gray", length(heights)), base = rep(0, length.out = length(heights))) {
	for (i in 1:length(heights)) {
		xp = c(x[i] - width, x[i] + width)
		poly(xp, base[i], heights[i], col[i], border = NA)
	}
	ebars(x, heights, sems, col = col, lwd = 3)
}

barplot.group = function(y1, y2, col = c("orange", "blue")) {
	col = rep(col, length.out = ncol(y1) + ncol(y2))

	m1 = m_sem(y1)
	m2 = m_sem(y2)

	a = barplot(t(cbind(m1[, 1], m2[, 1])), beside = T, col = col, names.arg = ASYNCS, xlim = c(1, 40), space = c(0, 
		0.75), border = F, ylim = c(0, 0.06))

	for (i in 1:nrow(m1)) {
		ebars.y(a[1, i], m1[i, 1], m1[i, 2], lwd = 2, col = col[1], down = F)
		ebars.y(a[2, i], m2[i, 1], m2[i, 2], lwd = 2, col = col[2], down = F)
	}
}

stack.plot = function(group, y, col, xAt = c(0, 10, 20, 30, 40), ...) {
	groups = sort(unique(group))
	y.uni = sort(unique(y))
	counts = sapply(y.uni, function(g) max(sum(y[group == groups[1]] == g, na.rm = T), sum(y[group == groups[2]] == 
		g, na.rm = T)))
	plot(range(y.uni, na.rm = T), range(c(0, 5 + counts), na.rm = T), type = "n", axes = F, ylab = "", xlab = "", ...)
	axis(1, at = xAt, labels = T)
	for (i in 1:length(groups)) {
		yg = y[group == groups[i]]
		y.uni = sort(unique(yg))
		counts = sapply(y.uni, function(g) sum(yg == g, na.rm = T))

		putStack(y.uni, counts, col = col[i])

		abline(v = median(rep(y.uni, counts)), col = col[i], lwd = 3)
	}
}

putStack = function(y.uni, counts, col, pch = 20, ...) {
	col = rep(col, length.out = length(counts))
	pch = rep(pch, length.out = length(counts))

	for (i in 1:length(counts)) {
		points(rep(y.uni[i], counts[i]), 1:counts[i], col = col[i], pch = pch[i], ...)
	}
}

plot.clean = function(xlim, ylim, mar = rep(1, 4), x = 1, y = 1, type = "n", xlab="", ylab="", ...) {
	if (!any(is.na(mar))) {
		par(mar = mar)
	}
	plot(x, y, type = type, axes = F, ylab = ylab, xlab = xlab, xlim = xlim, ylim = ylim, ...)
}

plot_pred = function(yhat, col = "black", ylim = c(-0.05, 1.05), names = NA) {
	x = barplot(yhat, col = col, ylim = ylim, axes = F, names = names, border = NA)
	axis(2, at = c(0, 0.5, 1), labels = F)
	abline(h = 0, lwd = 0.5)
	return(x)
}

plot.barfit = function(y, yhat, y.col = "black", yhat.col = "gray", error.col = "orangered", error_on_top = T, do_mean = T, 
	names = NA) {
	par(mar = rep(1, 4)) #put this here for now

	#tack on the mean
	if (do_mean) {
		yhat = c(yhat, NA, mean(yhat))
		y = c(y, NA, mean(y))
	}

	x = plot_pred(yhat, col = yhat.col, names = names)

	if (error_on_top) {
		bar_stool(x, y, wid = 0.4, lwd = 3)
		error_line(x, y, yhat, col = error.col)
	} else {
		error_line(x, y, yhat, col = error.col, lwd = 1)
		bar_stool(x, y, wid = 0.4, lwd = 3)
	}
}

bar_stool = function(x, y, ylo = 0, wid = 0.2/length(x), col = "black", lwd = 2, legs = F, ...) {
	for (i in seq(x)) {
		if (legs) {
			sapply(c(-wid, +wid), function(q) lines(c(x[i] + q, x[i] + q), c(ylo, y[i]), col = "darkgray", lwd = 1))
		}
		lines(c(x[i] - wid, x[i] + wid), c(y[i], y[i]), col = col, lwd = lwd, ...)
	}
}

error_line = function(x, y, y2, col = "orangered", lwd = 2) {
	for (i in seq(x)) lines(c(x[i], x[i]), c(y[i], y2[i]), col = col, lwd = lwd)
}

# # # # #	Wrapper functions	# # # # #
to_pdf = function(PLOT, w, h, mar=rep(1,4)) {
	return(function(..., fname, width = w, height = h, margin=mar) {
		pdf(fname, width = width, height = height)
		par(mar=margin)
		PLOT(...)
		dev.off()
	})
}

# a more flexible pdf wrapper that evaluates an arbitrary expression. 
as_pdf = function(file, w, h, expr) {
	pdf(file, width=w, height=h)
	res = eval(expr)	
	dev.off()
	
	return (invisible(res))
}




