########Common function helpers########

# ensure low <= x <= hi
clip = function(x, low = 1e-3, high = (1 - 1e-3), range=c(low, high)) {

	x[x < range[1]] = range[1]
	x[x > range[2]] = range[2]

	return(x)
}

# builds matrix with mean and se_mean
m_sem = function(mat) {
	if (is.null(mat)) {
		return(NA)
	}

	mat = as.matrix(mat)
	res = cbind(colMeans(mat, na.rm = T), apply(mat, 2, se))

	colnames(res) = rep(c("mean", "sem"), length.out = ncol(res))

	return(res)
}

# builds matrix with mean and sd
m_sd = function(mat) {
	mat = as.matrix(mat)
	res = cbind(colMeans(mat, na.rm = T), apply(mat, 2, sd, na.rm = T))

	colnames(res) = rep(c("mean", "sd"), length.out = ncol(res))

	return(res)
}


# NA aware standard error function
se = function(x) {
	d = sqrt(sum(!is.na(x)))
	return(sd(x, na.rm = T)/d)
}

sort_by = function(x, by) {
	idx = sort(by, index.return = T)$ix
	return(x[idx])
}

#
# strip out NA elements in lists and vectors
#
remove_na_from_collection = function(collection) {
	if (is.list(collection)) 
		return(lapply(which(!is.na(collection)), getElement, object = collection))
	if (is.vector(collection)) 
		return(collection[!is.na(collection)])

	stop("Input must be one of {list|vector}")
}

#
# divide each value by the sum total
# although simple, it is often used to wrap results of other function calls,
# thus avoiding intermediate storage
# by default it removes NA values from the sum (otherwise it would crash), 
# but leaves them in the resulting vector
#
scl = function(x, na.rm = TRUE) {
	x/sum(x, na.rm = na.rm)
}

# # # # #	Wrapper functions	# # # # #

# prints out a counter each time f is called
with_counter = function(f, end = "unknown") {
	counter__ = 1
	function(...) {
		cat("Starting Run", counter__, "of", end, "\n")
		counter__ <<- counter__ + 1
		f(...)
	}
}

# wraps f with a timer
with_timer = function(f, CLEANUP = NULL) {
	function(...) {
		begin = proc.time()

		out = f(...)

		end = proc.time()
		cat("\tElapsed Time: ", as.numeric(end - begin)[3], "\n")

		if (is.function(CLEANUP)) {
			CLEANUP(out)
		}

		return(out)
	}
}
