ebars.y = function(x, y, sem, length=0.05, up=T, down=T, ...)
{
	if(up) {
		arrows(x0=x, y0=as.numeric(y), y1=as.numeric(y+sem), angle=90, code=2,length=length, ...)
	}
	if(down) {
		arrows(x0=x, y0=as.numeric(y), y1=as.numeric(y-sem), angle=90, code=2,length=length, ...)
	}
}

m_sem = function (mat) {
	mat = as.matrix(mat)
	res = cbind(colMeans(mat, na.rm=T), apply(mat, 2, se))

	colnames(res) = rep(c('mean', 'sem'), length.out=ncol(res))
	
	return (res)
}

se = function(x) {
	d = sqrt(sum(!is.na(x)))
	return (sd(x, na.rm=T) / d)
}

getAlphaRGB = function(colname, alpha)
{
	c = col2rgb(colname)
	rgb(t(c), alpha=alpha, maxColorValue=255)
}

ebar_polygon = function(x, y, sem, col, border=NA)
{
	polygon(c(x, rev(x)), c(y+sem, rev(y-sem)), border=border, col=col)
}

#Plots line with error bars, each column is point
ebar_plot = function (x, mat, overlay=F, type='o', lwd=3, col='black', ebar.lwd=(lwd-1), ...)
{
	summ = m_sem(mat)

	if (overlay==F) {
		plot(x, summ[,1], type=type, lwd=lwd, col=col,...)
	} else {
		lines(x, summ[,1], type=type, lwd=lwd, col=col, ...)
	}

	ebars.y(x, summ[,1], summ[,2], lwd=ebar.lwd, col=col)
	
	invisible(summ)
}


plotModelComparison = function(m1, m2, names=colnames(mat), col=c('orange', 'blue'), ylim=c(0,1), xpd=F, yat=NA, axis.col='black', lwd=2, ...)
{
	m = m_sem(cbind(m1, m2))
	a = barplot(m[,1], col=col, names.arg=NA, horiz=F, axes=F, ylim=ylim, border=NA, xpd=xpd, ...)

	if(any(is.na(yat))) {
		yat = c(range(ylim), mean(ylim))
	}

	axis(2, at=yat, labels=F, col=axis.col)
	axis(1, at=c(0:(ncol(m)+1)), labels=F, lwd.ticks=0, col=axis.col)
	
	for(i in 1:nrow(m))
		ebars.y(a[i], m[i,1], m[i,2], lwd=lwd, col=col[i], down=F)
		
	invisible(a)
}

plotIndividualWithFitted = function(x, y, yh1, yh2, col = c('black', 'orange', 'blue'), lty=1, ...)
{
	plotClean(x, y, col=col[1], lty=lty, ...)
	lines(x, yh1, col=col[2], lwd=3, lty=lty)
	lines(x, yh2, col=col[3], lwd=3, lty=lty)

	doAxes(labels=F)
}

doAxes = function(doX=T, doY=T, xAt=c(-300, 0, 300, 500), yAt=c(0, 0.5, 1), ...)
{
	if (doX) axis(1, at=xAt, ...)
	if (doY) axis(2, at=yAt, ...)
}

plotMeanWithFitted = function(x, ymat, yh1mat, yh2mat, col = c('black', 'orange', 'blue'), ylim=c(0,1), withAxes=T, lty=1, alpha.fit=255, border=NA, axis.col='black', poly=F, pch=1)
{
	yh1 = m_sem(yh1mat)
	yh2 = m_sem(yh2mat)

	#setup axes	
	plotClean(x, ymat[1,], ylim=ylim, col=col[1], type='n')
	if(withAxes) doAxes(labels=F, col=axis.col)

	#plot actual data with error bars
	ebar_plot(x, ymat, overlay=T, lwd=2, col=col[1], type='p', lty=lty, ebar.lwd=2, pch=pch)
	
	#fitted values as polygons
	if(poly) {
		ebar_polygon(x, yh1[,1], yh1[,2], col=getAlphaRGB(col[2], alpha.fit), border=border)
		ebar_polygon(x, yh2[,1], yh2[,2], col=getAlphaRGB(col[3], alpha.fit), border=border)
	} else {
		lines(x, yh1[,1], col=getAlphaRGB(col[2], alpha.fit), lwd=2, type='l', lty=lty)
		lines(x, yh2[,1], col=getAlphaRGB(col[3], alpha.fit), lwd=2, type='l', lty=lty)
	}
}

plotClean = function(x, y, ylim=c(0,1), ...)
{
	plot(x, y, xlab='', ylab='', axes=F, ylim=ylim, ...)
}

addFittedPoly = function(x, yhmat, col='red', alpha=.5*255, border=NA)
{
	yh1 = m_sem(yhmat)
	ebar_polygon(x, yh1[,1], yh1[,2], col=getAlphaRGB(col, alpha), border=border)
}

parPlot = function(y1, y2, x=1:length(y1), ylim=c(0,1), col=c('darkgreen', 'purple'), ...)
{	
	ebar_plot(1:2, cims.fitted[,y1], col=col[1], xlim=c(0.75,2.25), axes=F, ylim=ylim, ...)
	ebar_plot(1:2, cims.fitted[,y2], col=col[2], o=T, ...)
	axis(1, at = c(1,2))
	axis(2, at=c(min(ylim), median(ylim), max(ylim)), las=1)
	
	invisible(m_sem(cbind(cims.fitted[,y1], cims.fitted[,y2])))
}
