#--Within-Condition Comparisons--#
within_condition_tests = function(cims.model, gauss.model)
{
	# calculate nLL for each model in each condition
	nLL.c = - logLik(cims.model, separate=T)
	nLL.g = - logLik(gauss.model, separate=T)
	
	colnames(nLL.c) = paste('CIMS_nLL', 1:.k, sep='.')
	colnames(nLL.g) = paste('GAUSS_nLL', 1:.k, sep='.')
	
	cat('\n\n##Mean and SEM for nLL:\n')
	print(m_sem(cbind(nLL.c, nLL.g)))

	# get mean difference per condition
	nLL.d = nLL.g - nLL.c
	colnames(nLL.d) = paste('G_minus_C_nLL', 1:.k, sep='.')
	cat('\n\n##Mean and SEM for nLL difference\n')
	print(m_sem(nLL.d))

	# get the odds ratios from the mean nLL per condition
	cat('\n\n##Odds-ratios per condition, >1 favors CIMS\n')
	or = as.matrix(exp(colMeans(nLL.d)))
	row.names(or) = paste('Condition', 1:.k, sep='.')
	colnames(or) = 'Odds-Ratio'
	print(or)
	
	cat('\n')
}

#--Overall Comparisions--#
across_condition_tests = function(cims.model, gauss.model)
{
	# lnL
	lnL = cbind(logLik(cims.model), logLik(gauss.model))
	colnames(lnL) = paste(c("CIMS", "GAUSS"), "logLik", sep=".")

	cat('\n\n##Mean and SEM lnLik values:\n')
	print(m_sem(lnL))
	
	cat('\n\n##Mean and SEM lnLik difference, > 0 favors CIMS:\n')
	print(m_sem(lnL[,1] - lnL[,2]))

	cat('\tRange of lnLik Differences:\n')	
	print(range(lnL[,1] - lnL[,2]))
	
	cat('\n\n##Testing lnLik...\n')
	print(wilcox.test(lnL[,1] - lnL[,2]))

	n = sum(lnL[,1] > lnL[,2])
	cat(c('CIMS model fits better for', n, 'of', nrow(lnL), 'subjects.\n'))
	
	invisible(lnL)
}
