#load model-specific builders
source('build_cims.R')
source("build_gauss.R")

#load analysis functions
source("cims_analyze.R")

# Load the plottting functions
source('model_plotters.R')

### ensure low <= x <= hi
clip = function(x, low=1e-6, hi=(1 - 1e-6)) {
	x[x<low] = low
	x[x>hi] = hi
	
	return(x)
}

### log L(y | p;n) = log(C) + log(p)*y + log(1-p)*(n-y)
LL.binomial = function (p, y, n)
{
	#ensure 0 < p < 1, b/c log(0) -> :(
	p = clip(p)
		
	q = 1-p
	
	s = y * log(p)
	f = (n-y) * log(q)
	
	ll = s + f

	return (ll)
}

loadVars = function()
{
	# how many conditions are there?
	.k <<- ncol(count_mat) / length(asyncs)
	
	# create a variable to allow indexing into the count_mat easily
	.idx <<- matrix(1:ncol(count_mat), ncol=.k)
	
	n.sub <<- nrow(count_mat)
}

### prep variables then export to cluster
setupClust = function()
{
	if(exists("cl")){
		stopCluster(cl)
	}

	loadVars()
	
	cl <<- makeCluster(detectCores())
	clusterExport(cl, c('count_mat', 'asyncs', 'max_count', '.k', '.idx', 'n.sub'))
}

### SSE / df.resid
rmsd = function (pred, y, n.par)
{
	n = length(y)
	
	resid = sum( (y-pred)**2 )
	rmsd = sqrt( resid/n ) * ( n/(n - n.par) )
		
	return (rmsd)
}

### 1 - ratio of SSE and SST
r2.pseudo = function(pred, y)
{
	resid = sum ( (y - pred)** 2)	
	tot   = sum ( (y - mean(y))**2)
	
	r2 = 1 - (resid)/(tot)
	
	return (r2)
}

### prints out a counter each time the function f is called
with_counter = function(f, end='unknown') {
	i = 1
	function (...) {
		cat("Starting Run", i, 'of', end, "\n")
		i <<- i + 1
		f(...)
	}
}

### wraps a function with a timer
with_timer = function(f) {
	function (...) {
		begin = proc.time()
	
		out = f(...)
	
		end = proc.time()
		cat('\tElapsed Time: ', as.numeric(end-begin)[3], '\n')

		if(! is.null(attr(out, 'nLL')) ) {
			cat('\tneg_lnL: ', out$nLL, '\n')
		}


		return(out)	
	}
}
