cims = function(n.reps=64)
{
	setupClust()

	gpars = cbind(0, runif(n.reps, 1, 150), runif(n.reps, -200, 0), runif(n.reps, 100, 300))

	t_optim = with_counter(with_timer(optim.cims), n.reps)

	res = apply(gpars, 1, t_optim)

	idx = which.min(sapply(res, function(x) x$nLL))
	best = res[[idx]]

	best$df = .k+1 + 3

	class(best) = 'cims'

	colnames(best$spars) = c('pc1', paste0('sd_cond', 1:.k), 'muc1', 'sdc1', 'muc2', 'sdc2', 'neg_lnL')

	write.csv(best, file='cims_out.csv')
	
	invisible(best)
}

optim.subj_only = function(y, gpars)
{
	source('cims.R')
	nLL = Inf
	for(p1 in seq(.01, .99, length.out = 4)) {
		sds = rep(0,.k)
		for(i in 1:20) {
			sds = apply(.idx, 2, function(i) optimize(negLL.cims, c(1,1e3), p1=p1, gpars=gpars, y=y[i])$minimum)
			
			h = optimize(negLL.subj, c(1e-6, 1 - 1e-6), sds=sds, gpars=gpars, y=y)	
			p1 = h$minimum

			if (h$objective < nLL) {
				nLL = h$objective
				fullpars = c(p1, sds, gpars, nLL)
			}
		}
	}
	return (fullpars)
}


cims.subj_only = function(gpars)
{
	setupClust()
	sbj = t(array(parRapply(cl, count_mat, optim.subj_only, gpars=gpars), c(.k+2+4, nrow(count_mat))))

	cm = list()
	cm$spars = sbj
	cm$df = .k+1
	
	class(cm) = 'cims'

	return(cm)
}

load_cims_model = function(file='cims_out.csv')
{
	d = read.csv(file, header=T, row.names=1)
	k = ncol(d) - 1

	cm = list()
	cm$df = d$df[1]
	cm$spars = d[,1:k]
	cm$neg_lnL = sum(cm$spars[,k])
	
	class(cm) = 'cims'
	
	return(cm)
}

as.data.frame.cims = function(x, ...)
{
	df = data.frame(x$spars)

	df$df = x$df

	return(df)
}

optim.cims = function(gpars)
{
	spars = t(array(parRapply(cl, count_mat, optim.subj, gpars=gpars), c(.k+2+4, nrow(count_mat))))

	return (list(nLL=sum(spars[,10]), spars=spars))
}

optim.subj = function(y, gpars, n.steps=20, p.seqlen=10)
{
	# because this method is getting called in its own thread
	# source the file to ensure the relevant methods are in scope
	source('cims.R')
	
	orig.gpars = gpars

	nLL = Inf
	for(p1 in seq(.01, .99, length.out = p.seqlen)) {
		sds = rep(0,.k)
		
		gpars = orig.gpars
		for(i in 1:n.steps) {
			sds = apply(.idx, 2, function(i) optimize(negLL.cims, c(1,1e3), p1=p1, gpars=gpars, y=y[i])$minimum)

			h = optimize(negLL.subj, c(1e-6, 1 - 1e-6), sds=sds, gpars=gpars, y=y)	
			p1 = h$minimum

			gpars[2] = optimize(function(sd1) negLL.subj(sds, p1, c(gpars[1], sd1, gpars[3:4]), y=y), c(0, 150))$minimum
			gpars[3] = optimize(function(m2) negLL.subj(sds, p1, c(gpars[1:2], m2, gpars[4]), y=y), c(-200, 0))$minimum
			
			h = optimize(function(sd2) negLL.subj(sds, p1, c(gpars[1:3], sd2), y=y), c(gpars[2], 300))
			gpars[4] = h$minimum
			

			if (h$objective < nLL) {
				nLL = h$objective
				fullpars = c(p1, sds, gpars)
			}
		}
	}
	return (c(fullpars, nLL))	
}

negLL.gpar.parallel = function(i, spars, gpars)
{
	source("cims.R")
	negLL.subj(spars[i, 2:(.k+1)], spars[i,1], gpars, count_mat[i,])
}

negLL.gpar = function(m1, m2, sd1, sd2, spars, y)
{
	negLL.subj(spars[2:(.k+1)], spars[1], c(m1,m2,sd1,sd2), y)
}

negLL.subj = function(sds, p1, gpars, y)
{
	sum(sapply(seq(.k), function(i) negLL.cims(p1, sds[i], gpars, y[.idx[,i]])))
}

negLL.cims = function(p1, sd, gpars, y)
{
	p = pred.cims(asyncs, p1, sd, gpars[1], gpars[2], gpars[3], gpars[4])
	ll = LL.binomial(p, y, max_count)

	return (-sum(ll))
}

logLik.cims = function(object, ..., separate=F)
{
	cims.p = predict(object)

	#calc ll for each condition		
	ll = apply(.idx, 2, function(i) rowSums(LL.binomial(cims.p[,i], count_mat[,i], max_count)))

	if (!separate){
		ll = rowSums(ll)

		n = max_count*ncol(count_mat)

		#let's check if the df is already stored	
		if(any(names(object) == 'df')) {
			df = object$df
		} else {
			df = ncol(object$spars)-2
		}

		attributes(ll) = list(df=df, nobs=n, nall=n)
	
		class(ll) = 'logLik'
	}

	return (ll)
}


as.var = function(sd)
{
	if (sd < 1e-7)
		return(1e-7)

	return (sd**2)
}

pred.cims = function (async, p1, sd, m1, sd1, m2, sd2)
{
	#safely transform sd into variance
	var.1 = as.var(sd1)
	var.2 = as.var(sd2)
	var.x = as.var(sd)

	p1 = clip(p1)
	
	lprior = 2 * log(p1 / (1-p1))
	
	b = log((var.x + var.2) / (var.x + var.1)) +  (m2**2 / (var.2 - var.1))
	
	c = (1 / (var.x + var.1)) - (1 / (var.x + var.2)) 

	if (lprior < -b) {
		lprior = -b
	}

	bound = sqrt((lprior+b)/c)
	middle = abs(m2) * (var.x+var.1)/(var.2-var.1)

	upper = middle + bound
	lower = middle - bound

	p.cdf = pnorm(upper, async, sd) - pnorm(lower, async, sd)

	return (p.cdf)
}

predict.cims.par = function(pars, x=NA)
{
	if(is.na(x)) {
		x = asyncs
	}
	
	return(pred.cims(x, pars[1], pars[2], pars[3], pars[4], pars[5], pars[6]))
}

predict.cims = function(object, ...)
{
	spars = object$spars
	sds = object$spar[,2:(.k+1)]

	pred = array(0, c(nrow(count_mat), .k*length(asyncs)))
	for(i in 1:.k) {
		pars = cbind(spars[,c(1,1+i,6:9)])
		pred[,.idx[,i]] = t(apply(pars, 1, predict.cims.par))
	}

	return(pred)
}
