# rsid:1799884
# rsid:1260326
# rsid:560887
# rsid:10830963
# Disease: Diabetes Mellitus, Non-Insulin-Dependent
# Source: Reiling et al. 2009, Dutch New Hoorn Study
# PMID: 19533084
# Author: Joseph P. Torella
# Model: Genetic Score
# Output: Relative risk of disease by age 53, compared to the general population
# Caveats: Genotype cannot on its own predict diabetes risk, which varies substantially with age, race, BMI and family history.

# Import libraries
import sys

# Check for all inputs
if sys.argv[1].count('x') + sys.argv[2].count('x') + sys.argv[3].count('x') + sys.argv[4].count('x') > 0:
    print 'ERROR'

# Calculate overall risk
risk_alleles = sys.argv[1].count('A') + sys.argv[2].count('C') + sys.argv[3].count('G') + sys.argv[4].count('G')
if risk_alleles == 0 or risk_alleles == 1:
    Risk = .75
    Lower = .55
    Upper = 1.02
if risk_alleles == 2:
    Risk = .78
    Lower = .64
    Upper = .95
if risk_alleles == 3:
    Risk = .89
    Lower = .76
    Upper = 1.04
if risk_alleles == 4:
    Risk = 1.00
    Lower = .81
    Upper = 1.18
if risk_alleles == 5:
    Risk = 1.17
    Lower = .97
    Upper = 1.41
if risk_alleles == 6 or risk_alleles == 7 or risk_alleles == 8:
    Risk = 2.05
    Lower = 1.50
    Upper = 2.80

print 'RR',Risk,Lower,Upper
