# rsid:rs1799752
# rsid:6025
# rsid:429358
# rsid:1801133
# rsid:4340
# rsid:13447447
# rsid:4646994
# Disease: Ischemic Stroke (Small-Vessel)
# Source: Szolnoki et al. 2002, Pandy Kalman Hospital, Hungary
# PMID: 12382154
# Author: Joseph P. Torella
# Model: Hypothesis-Based
# Output: Risk of small-vessel ischemic stroke relative to the general population
# Caveats: Genotype cannot on its own predict the risk of ischemic stroke, which varies substantially with age, race, family history and environmental factors.

# Import libraries
import sys
import math

# Check for all inputs
if sys.argv[1].count('x') + sys.argv[2].count('x') + sys.argv[3].count('x') + sys.argv[4].count('x') + sys.argv[5].count('x') + sys.argv[6].count('x') + sys.argv[7].count('x') > 0:
    print 'ERROR'
    
# Not included in model:
if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[2].count('A') > 0) and (sys.argv[3].count('C') > 0) and (sys.argv[4].count('T') > 0):
    print 'ERROR' 

# Calculate overall risk

# In case no risk factors are found
Risk = 1
Lower = 1
Upper = 1

# ACE D/D
if sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0':
    Risk = 2.8
    Lower = 1.4
    Upper = 5.4

# Leiden V
#if sys.argv[2].count('A') > 0:
#    Risk = 1.0
#    Confidence_Interval = .4

# APOE 4
if sys.argv[3].count('C') > 0:
    Risk = 3.2
    Lower = 1.3
    Upper = 7.8

# ACE D/D + APOE4
if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[3].count('C') > 0):
    Risk = 10.9
    Lower = 3.6
    Upper = 33.2

# ACE D/D + MTHFR 677T
if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[4].count('T') > 0):
    Risk = 6.2
    Lower = 3.1
    Upper = 12.3

# ACE D/D + MTHFR 677T + APOE4
if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[4].count('T') > 0) and (sys.argv[3].count('C') > 0):
    Risk = 11.9
    Lower = 3.8
    Upper = 37.4

# Leiden V + ACE D
#if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[2].count('A') > 0):
#    Risk =
#    Confidence_Interval =

# Leiden V + MTHFR 677T
#if (sys.argv[2].count('A') > 0) and (sys.argv[4].count('T') > 0):
#    Risk =
#    Confidence_Interval =

# Leiden V + ACE D + MTHFR 677T
#if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[2].count('A') > 0) and (sys.argv[4].count('T') > 0):
#    Risk =
#    Confidence_Interval =

# Leiden V + APOE4 + ACE D
#if (sys.argv[1] != '0' or sys.argv[5] != '0' or sys.argv[6] != '0' or sys.argv[7] != '0') and (sys.argv[2].count('A') > 0) and (sys.argv[3].count('C') > 0):
#    Risk =
#    Confidence_Interval =    

print 'RR',Risk,Lower,Upper
