# rsid:4430796
# rsid:1859962
# rsid:16901979
# rsid:6983267
# rsid:1447295
# Disease: Prostate Carcinoma
# Source: Zheng et al. 2008, Cancer Prostate in Sweden (CAPS) Study
# PMID: 18199855
# Author: Joseph P. Torella
# Model: Logistic Regression
# Output: Risk of prostate cancer by 65-80 years of age
# Caveats: Genotype cannot on its own predict prostate cancer risk, which varies substantially with age, race, lifestyle and family history.

# Import libraries
import sys
import math

# Check for all inputs
if sys.argv[1].count('x') + sys.argv[2].count('x') + sys.argv[3].count('x') + sys.argv[4].count('x') + sys.argv[5].count('x') > 0:
    print 'ERROR'

# Calculate overall risk
OR = [1,1,1,1,1]
CI = [0,0,0,0,0]

if sys.argv[1] == 'TT':
    OR[0] = 1.38
    CI[0] = 1.14
if sys.argv[2] == 'GG':
    OR[1] = 1.28
    CI[1] = 1.15
if sys.argv[3] == 'AA' or sys.argv[3] == 'CA' or sys.argv[3] == 'AC':
    OR[2] = 1.53
    CI[2] = 1.25
if sys.argv[4] == 'GT' or sys.argv[4] == 'GG' or sys.argv[4] == 'TG':
    OR[3] = 1.37
    CI[3] = 1.16
if sys.argv[5] == 'CA' or sys.argv[5] == 'AC' or sys.argv[5] == 'AA':
    OR[4] = 1.22
    CI[4] = 1.15

Rel_Risk = (OR[0]*OR[1]*OR[2]*OR[3]*OR[4])*.114
Confidence_Interval = pow((pow(CI[0],2) + pow(CI[1],2) + pow(CI[2],2) + pow(CI[3],2) + pow(CI[4],2)),.5)

Rel_Lower = Rel_Risk
Rel_Upper = Rel_Risk

if Confidence_Interval > 0:
    Rel_Lower = Rel_Risk / Confidence_Interval
    Rel_Upper = Rel_Risk * Confidence_Interval

Risk = 100*Rel_Risk / (1 + Rel_Risk)
Lower = 100*Rel_Lower / (1 + Rel_Lower)
Upper = 100*Rel_Upper / (1 + Rel_Upper)

print 'PCT',Risk,Lower,Upper
