%Question 3 - Hodgkin-Huxley Equations

close all; clc; clear all;

global gt gh I tr

iconds = [-0.8 0.3 0.3 1];

%Regular Spiking values
gt = 0.1;
gh = 5;
tr = 4.2;
time = [0:1e-3:300];

%Fast spiking cells
% gt = 0.25;
% gh = 0;
% tr = 1.5;
% time = 0:1e-3:150;

%Continuous bursting
% gt = 2.25;
% gh = 9.5; 
% tr = 4.2;
% time = 0:1e-3:600;

% ivals = 0.8; %For continuous bursting (part 4)
ivals = [0.1 0.2 0.4 0.6 0.8 1 1.5];
for j = 1:length(ivals)
    I = ivals(j);
    [t x] = ode45(@hdhux,time,iconds);
    tvals(j,:) = t;
    xvals(j,:) = x(:,1);
end

figure;
for j = 1:length(ivals)
%     subplot(2,4,j), 
    plot(tvals(j,:),xvals(j,:));
    title(['I = ', num2str(ivals(j))])
    xlabel('Time (ms)')
    ylabel('Voltage (x 10^-2 mV)')
end

%Spike Counter and spike rate from begint to 300 (more accurate)
begint = 100;
beginn = begint/1e-3;
for j = 1:length(ivals)
    i = 0; %Initiate Counter
    for n = beginn:length(xvals(j,:))
        if xvals(j,n) > 0 && xvals(j,n-1) < 0 %Set threshold to 0
            i = i+1;
        end
    end
    spkctr(j,:) = [ivals(j) i i/((300-begint)*0.001)];
end

%Plot spike rate for each value of I
figure;
for j = 1:length(ivals)
    plot(spkctr(:,1), spkctr(:,3))
    hold on;
    plot(spkctr(:,1), spkctr(:,3),'xred')
end
title('Figure 11. Spike Rate vs. Injected Current')
xlabel('Injected Current (nA)')
ylabel('Spike rate (1/s)')
hold off;
