%Question 2 - Period Doubling

clear all; clc; close all;
%Part 1
global c

% time = 0:0.1:100;
time = [0:0.1:2000];
iconds = [5 -1 1];

cvals = [2.6 3.5 4.1 5];
for i = 1:length(cvals)
    c = cvals(i);
    [t x] = ode45(@pdubfun, time, iconds);
    tvals(i,:) = t(1:length(t));
    xvals(i,:) = x(1:length(x),1);
    yvals(i,:) = x(1:length(x),2);
    zvals(i,:) = x(1:length(x),3);
%     subplot(2,1,1), plot(t,x(:,1));
%     hold on;
%     subplot(2,1,2), plot(x(:,1),x(:,2));
%     hold on;
end
% hold off

%Plot x trajectory for each value of c
% figure;
% for i = 1:length(cvals)
%     subplot(2,2,i), plot(tvals(i,:),xvals(i,:))
%     title(['c = ',num2str(cvals(i))]);
%     xlabel('Time');
%     ylabel('x(t)');
% end

%Plot y trajectory for each value of c
% figure;
% for i = 1:length(cvals)
%     subplot(2,2,i), plot(tvals(i,:),yvals(i,:))
%     title(['c = ',num2str(cvals(i))]);
%     xlabel('Time');
%     ylabel('x(t)');
% end

%Plot phase plane x vs. y for each value of c
% figure;
% for i = 1:length(cvals)
%     subplot(2,2,i), plot(xvals(i,:),yvals(i,:))
%     title(['c = ', num2str(cvals(i))]);
%     xlabel('x');
%     ylabel('y');
% end

%Power spectral density
% fsamp = 500;
% figure;
% for i = 1:length(cvals)
% %     psdvect = fft(xvals(i,:));
%     [PSDVect, freqvect] = pwelch(xvals(i,:),[],[],[],fsamp);
%     subplot(2,2,i), semilogy(freqvect(1:100),PSDVect);
%     title(['c = ',num2str(cvals(i))])
% end

%Power Spectrum 
figure;
for i = 1:length(cvals)
    xfft = fft(yvals(i,:),length(yvals(i,:))+1);
    xfftshift = abs(fftshift(xfft));
    x1 = 0:length(yvals(i,:));
    x1shift = -length(yvals(i,:))/2:length(yvals(i,:))/2;
    truncx1low = length(x1shift)/2 - length(x1shift)/12;
    truncx1hi = length(x1shift)/2 + length(x1shift)/12;
    subplot(2,2,i), plot(x1shift(truncx1low:truncx1hi),xfftshift(truncx1low:truncx1hi))
    title(['c = ', num2str(cvals(i))])
    xlabel('Frequency')
end
