%Question 1 - Lorentz System

close all; clear all; clc;
global sig b r

sig = 10;
b = 8/3;

time = [0:0.01:50];
Iniconds = [0 -1 0];



%Plot x(t)
rvals = [10 24.5 25 45 220];
for i = 1:length(rvals)
    r = rvals(i);
    [t x] = ode45(@lorentz,time,Iniconds);
    subplot(2,3,i), plot(t,x(:,1));
    title(['r = ',num2str(r)])
end

%Finding fixed points
for i = 1:length(rvals)
    r = rvals(i);
    fp(i,1) = sqrt(b*(r-1)); %Would be +/-
    fp(i,2) = sqrt(b*(r-1)); %Woulbe be +/-
    fp(i,3) = r-1;
end
fp;

%Plot x vs y on phase plane
figure;
for i = 1:length(rvals)
    r = rvals(i);
    [t x] = ode45(@lorentz,time,Iniconds);
    subplot(2,3,i), plot(x(:,1),x(:,2));
    title(['r = ',num2str(r)])
    xlabel('x');
    ylabel('y');
end

%Plot showing sensitivity to initial conditions
figure;
r = 10;
[t x] = ode45(@lorentz,time,[0 1 0]);
[t1 x1] = ode45(@lorentz,time,[0 -1 0]);
subplot(1,2,1), plot(x(:,1),x(:,2));
title('Figure 2a. Initial Condition (0,1,0)')
xlabel('x');
ylabel('y');
subplot(1,2,2), plot(x1(:,1),x1(:,2));
title('Figure 2b. Initial Condition (0,-1,0)')
xlabel('x');
ylabel('y');

%Part 2 fixing points and values
time1 = [0:0.001:20];
r = 28;
iconds1 = [8.8756 16.1229 11.5828];
iconds2 = [8.8757 16.1230 11.5829];
[t1 x1] = ode45(@lorentz,time1,iconds1);
[t2 x2] = ode45(@lorentz,time1,iconds2);

figure;
plot(t1,x1(:,1))
hold on;
plot(t2,x2(:,1),'--red')
title('Figure 4. Sensitivity to Initial Conditions')
xlabel('Time')
ylabel('x(t)')
hold off

%Finding the liapunov exponent
deltavals = log(abs(x2(:,1) - x1(:,1)));
figure;
plot(t1,deltavals)
hold on;
N = 16/0.001;
F = polyfit(t1(1:N),deltavals(1:N),1)
g = polyval(F,t1(1:N));
plot(t1(1:N),g)
title('Figure 5. Finding the Lyapunov Exponent')
hold off;
