tic
% by Jesse Smith for analysis of data taken in Physics307L Poisson distribution lab
% I've saved the output of the MCA program (except for the first few lines of text)
% as variables in a Matlab data file.  The variables are 'jk1ms','jk2ms', etc.

clear;
%% Load Data as Matrices
load jk.mat; % Load the Matlab data file
dwelltimes = [1 2 4 8 10 20 40 80 100 200 400 800 1000 2000 4000];
data1 = [jk1ms(:,2), jk2ms(:,2), jk4ms(:,2), jk8ms(:,2)];
data2 = [jk10ms(:,2), jk20ms(:,2), jk40ms(:,2)];
data3 = jk80ms(:,2);
data4 = [jk100ms(:,2), jk200ms(:,2), jk400ms(:,2), jk800ms(:,2)];
data5 = [jk1s(:,2), jk2s(:,2), jk4s(:,2)];

%% Calculate Std. Devs. and Means of Raw Data
stdevs = [std(data1) std(data2) std(data3) std(data4) std(data5)];
% means = [mean(data1) mean(data2) mean(data3) mean(data4) mean(data5)];
%% Plot Data
% Make figures of raw MCA Output
scrsz = get(0,'ScreenSize');
figure('Position',[10, 50, scrsz(3)*0.6, scrsz(4)*0.6]);
subplot(2,2,1);
plot(jk1ms(:,1),jk1ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 1ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,2);
plot(jk2ms(:,1),jk2ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 2ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,3);
plot(jk4ms(:,1),jk4ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 4ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,4);
plot(jk8ms(:,1),jk8ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 8ms');
xlabel('Channel');
ylabel('Number of Events');

figure('Position',[10, 50, scrsz(3)*0.6, scrsz(4)*0.6]);
subplot(2,2,1);
plot(jk10ms(:,1),jk10ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 10ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,2);
plot(jk20ms(:,1),jk20ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 20ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,3);
plot(jk40ms(:,1),jk40ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 40ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,4);
plot(jk80ms(:,1),jk80ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 80ms');
xlabel('Channel');
ylabel('Number of Events');

figure('Position',[10, 50, scrsz(3)*0.6, scrsz(4)*0.6]);
subplot(2,2,1);
plot(jk100ms(:,1),jk100ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 100ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,2);
plot(jk200ms(:,1),jk200ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 200ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,3);
plot(jk400ms(:,1),jk400ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 400ms');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,4);
plot(jk800ms(:,1),jk800ms(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 800ms');
xlabel('Channel');
ylabel('Number of Events');

figure('Position',[10, 50, scrsz(3)*0.6, scrsz(4)*0.6]);
subplot(2,2,1);
plot(jk1s(:,1),jk1s(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 1s');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,2);
plot(jk2s(:,1),jk2s(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 2s');
xlabel('Channel');
ylabel('Number of Events');

subplot(2,2,3);
plot(jk4s(:,1),jk4s(:,2),'s','MarkerSize',4);
title('Raw Data, Dwell Time 4s');
xlabel('Channel');
ylabel('Number of Events');
clear scrsz;
clear jk1ms jk2ms jk4ms jk8ms jk10ms jk20ms jk40ms jk80ms;
clear jk100ms jk200ms jk400ms jk800ms jk1s jk2s jk4s;
%% Lambda Estimation
% find estimated lambda for each set of data
lambdas = [poissfit(data1) poissfit(data2) poissfit(data3) poissfit(data4) poissfit(data5)]; 
%   determines the estimated lambda (max. likelihood of number of events)

%test for reasonableness: plot dwell times vs. lambda
figure;
loglog(dwelltimes,lambdas,'x-');
title('Lambda vs. Dwell Time');
xlabel('Dwell Time (milliseconds)');
ylabel('Lambda');
%% Probability Distrubtion Calculations
% calculate stuff to plot and compare: poisson pdf 'prediction', gauss pdf
% 'prediction', and data histogram

nu1 = linspace(0,4,5);
nu2 = linspace(0,6,7);
nu3 = linspace(0,16,17);
nu4 = linspace(0,50,51);

nu1mat = (nu1'*ones(1,4))';
nu2mat = (nu2'*ones(1,4))';
nu3mat = (nu3'*ones(1,4))';
nu4mat = (nu4'*ones(1,3))';

lambdas1=lambdas(1:4)'*ones(1,5);
lambdas2=lambdas(5:8)'*ones(1,7);
lambdas3=lambdas(9:12)'*ones(1,17);
lambdas4=lambdas(13:15)'*ones(1,51);

poiss1 = poisspdf(nu1mat,lambdas1);
poiss2 = poisspdf(nu2mat,lambdas2);
poiss3 = poisspdf(nu3mat,lambdas3);
poiss4 = poisspdf(nu4mat,lambdas4);

norm1 = normpdf(nu1mat,lambdas1,lambdas1.^0.5);
norm2 = normpdf(nu2mat,lambdas2,lambdas2.^0.5);
norm3 = normpdf(nu3mat,lambdas3,lambdas3.^0.5);
norm4 = normpdf(nu4mat,lambdas4,lambdas4.^0.5);

datahist1 = (histc(data1,nu1)./length(data1))';
datahist2 = (histc(data2,nu2)./length(data2))';
datahist3 = (histc(data3,nu2)./length(data3))';
datahist4 = (histc(data4,nu3)./length(data4))';
datahist5 = (histc(data5,nu4)./length(data5))';

bignu1mat = (linspace(0,4,100)'*ones(1,4))';
bignu2mat = (linspace(0,6,100)'*ones(1,4))';
bignu3mat = (linspace(0,16,100)'*ones(1,4))';
bignu4mat = (linspace(0,50,100)'*ones(1,3))';

means1 = lambdas(1:4)'*ones(1,100);
means2 = lambdas(5:8)'*ones(1,100);
means3 = lambdas(9:12)'*ones(1,100);
means4 = lambdas(13:15)'*ones(1,100);

stdevs1 = stdevs(1:4)'*ones(1,100);
stdevs2 = stdevs(5:8)'*ones(1,100);
stdevs3 = stdevs(9:12)'*ones(1,100);
stdevs4 = stdevs(13:15)'*ones(1,100);

norm1plot = normpdf(bignu1mat,means1,stdevs1);
norm2plot = normpdf(bignu2mat,means2,stdevs2);
norm3plot = normpdf(bignu3mat,means3,stdevs3);
norm4plot = normpdf(bignu4mat,means4,stdevs4);

clear lambdas1 lambdas2 lambdas3 lambdas4
clear nu1mat nu2mat nu3mat nu4mat
clear stdevs1 stdevs2 stdevs3 stdevs4
clear bignu1mat bignu2mat bignu3mat bignu4mat

%% Figures
% Make some figures: Poisson PDF, Gaussian PDF and Data vs. Number of
% Events

%call file 'fig.m' to make plots:
fig(nu1,poiss1(1,:),datahist1(1,:),linspace(0,4,100),norm1plot(1,:),'1ms',lambdas(1));
fig(nu1,poiss1(2,:),datahist1(2,:),linspace(0,4,100),norm1plot(2,:),'2ms',lambdas(2));
fig(nu1,poiss1(3,:),datahist1(3,:),linspace(0,4,100),norm1plot(3,:),'4ms',lambdas(3));
fig(nu1,poiss1(4,:),datahist1(4,:),linspace(0,4,100),norm1plot(4,:),'8ms',lambdas(4));
fig(nu2,poiss2(1,:),datahist2(1,:),linspace(0,6,100),norm2plot(1,:),'10ms',lambdas(5));
fig(nu2,poiss2(2,:),datahist2(2,:),linspace(0,6,100),norm2plot(2,:),'20ms',lambdas(6));
fig(nu2,poiss2(3,:),datahist2(3,:),linspace(0,6,100),norm2plot(3,:),'40ms',lambdas(7));
fig(nu2,poiss2(4,:),datahist3(1,:),linspace(0,6,100),norm2plot(4,:),'80ms',lambdas(8));
fig(nu3,poiss3(1,:),datahist4(1,:),linspace(0,16,100),norm3plot(1,:),'100ms',lambdas(9));
fig(nu3,poiss3(2,:),datahist4(2,:),linspace(0,16,100),norm3plot(2,:),'200ms',lambdas(10));
fig(nu3,poiss3(3,:),datahist4(3,:),linspace(0,16,100),norm3plot(3,:),'400ms',lambdas(11));
fig(nu3,poiss3(4,:),datahist4(4,:),linspace(0,16,100),norm3plot(4,:),'800ms',lambdas(12));
fig(nu4,poiss4(1,:),datahist5(1,:),linspace(0,50,100),norm4plot(1,:),'1s',lambdas(13));
fig(nu4,poiss4(2,:),datahist5(2,:),linspace(0,50,100),norm4plot(2,:),'2s',lambdas(14));
fig(nu4,poiss4(3,:),datahist5(3,:),linspace(0,50,100),norm4plot(3,:),'4s',lambdas(15));

clear norm1plot norm2plot norm3plot norm4plot
%% Goodness of Fit
%Examine "goodness of fit" (chi-square) for Poisson distribution vs. data 
%and Gaussian distribution vs. data Calls the "fit" function, defined in 
%"fit.m", which will return the sum of differencecs for the Gaussian PDF 
%prediction from the data histogram, and the sum of differences for the 
%Poisson PDF from the data histogram.  It also plots the differences vs. 
%estimated lambda in a log-log plot.

gausschisquare = [fit(norm1,datahist1,stdevs(1:4)), fit(norm2(1:3,:),datahist2,stdevs(5:7)), fit(norm2(4,:),datahist3,stdevs(8)), fit(norm3,datahist4,stdevs(9:12)), fit(norm4,datahist5,stdevs(13:15))];
poisschisquare = [fit(poiss1,datahist1,stdevs(1:4)), fit(poiss2(1:3,:),datahist2,stdevs(5:7)), fit(poiss2(4,:),datahist3,stdevs(8)), fit(poiss3,datahist4,stdevs(9:12)), fit(poiss4,datahist5,stdevs(13:15))];

figure;
loglog(lambdas,gausschisquare,'x-',lambdas,poisschisquare,'s-');
legend('Gauss. Diff.','Poiss. Diff.');
title('\chi^2 vs. \lambda');
xlabel('\lambda');
ylabel('\chi^2');

%% Compare Std. Devs. of Raw Data with Std. Devs. of Poisson Distribution
% In Poisson Distribution, std. deviation is sqrt(lambda).  I'd like to
% check whether this fits the standard deviations of my raw numbers (0
% events, 0 events, 1 event, 0 events, 0 events, etc.)
figure;
loglog(dwelltimes,lambdas.^0.5,'x',dwelltimes,stdevs,'s');
title('Standard Deviations vs. Dwell Time');
xlabel('Dwell Times (ms)');
ylabel('Standard Deviation');
legend('Poisson Distribution Std.Dev.','Raw Data Std.Dev.');
toc