import Energy;
from Protein import Protein;
from Topology import Topology;
from Residue import Residue;
from RotamerLib import RotamerLib;

top = Topology('top_all27_prot_na.inp');
rotolib = RotamerLib('bbind02.May.lib');
lj = Energy.loadLJParameters('lj_params.inp');

# Assign a protein object but do not built rotamers automatically
p = Protein( top, rotolib, "MPR" );
# Now build rotamers
for res in p.getResidues():
    res.buildAnonymousRotamers( top, rotolib );

# or build them automatically
p2 = Protein( top, rotolib, "MPR", True );

# neither protein object has any selected rotamers so let's select them
for res in p.getResidues():
    res.selectRotamer(0); # use first rotamer

for res in p2.getResidues():
    res.selectRotamer(0); # use first rotamer

# generate the PDB
p.toPDB();

# generate the PDB
p2.toPDB();

# anonymous residues
res = Residue();
res.buildBackbone( top );

# this would build all rotamers considering all possible residues
#res.buildRotamers( top, rotolib );
# or only a single residue
#res.buildRotamers( top, rotolib, 'MET' );
# or a list of residues
res.buildRotamers( top, rotolib, ['MET', 'TRP', 'ARG'] );

# do some calcs to figure out which rotamer is best, then select it
res.selectRotamer(0);
res.getAA(); # now i'm a MET



# the rotamer class exports a "chainEnergy" method
# it applies to the atoms in the current rotamer and will compute the
# pairwise energy between those atoms and the atoms in a list passed
# as the first argument.  the second argument specifies an energy
# function.  the following are valid:
#
# Energy.lennardJones
# Energy.naiveDielectric
# Energy.sternbergDielectric
#
# finally you must pass in the LJ params data structure (here called "lj")
# as the third param if using Energy.lennardJones.
#
p2.getResidues(0).getRotamer(0).chainEnergy( p2.getResidues(1).getRotamer(0).getAtoms(True), Energy.lennardJones, lj );
p2.getResidues(0).getRotamer(0).chainEnergy( p2.getResidues(1).getRotamer(0).getAtoms(True), Energy.sternbergDielectric );

