clear all

t0  = 0;     %initial time
t1  = 100;    % final time
x0  = 2;     % initial cell population
y0  = 2;    % initial yeast concentration
z0  = 2;   % initial ammonium concentration
%
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];

%
% rate constants and problem parameters
%
r   = 2;
K   = 15;
ep  = 1.1;
u   = 6;
q   = 0.15;
F   = 1.2;
L   = 15;
v   = 5;
%
% rate constants into parameter vector
%
params(1) = q;
params(2) = u;
params(3) = r;
params(4) = K;
params(5) = ep;
params(6) = L;
params(7) = F;
params(8) = v;
%
% define function for fixed parameter values
%
AA_chemostat_2nutrient_dynamics_params = @(t,S)AA_chemostat_2nutrient_dynamics(t,S,params);

%
% call the matlab function to solve the DE for us.
%
[t,St] = ode45(AA_chemostat_2nutrient_dynamics_params,[t0 t1],S0);
%
% Plot the results.
%
plot(t,St,'LineWidth',3)

legend('cells','food','ammonium')
xlabel('time')
ylabel('states')
axis([0,100,0,6])
