% 
% mM to gram conversions
% 
mm2gGlu    = 0.18018;     
mm2gAmm    = 0.018038;
percentAmm = 36/132;

%
% dilution rate
%
q   = 0.03;
%
% feed rates for the four cases
%
uu  = 25;
vv  = 5*percentAmm; % corrected for actual feed in Tai
%
% growth rate found by Leanne in the literature and verified in DL
% Values of K and L from optimization
%

K  = 0.8;
% L  = 0.04;
L  = 0.04;

%
% residual concentrations from Tai et al (2007)
%
rG = 1.5*mm2gGlu
rA = 65.2*mm2gAmm

%
% yields from Tai et al (2007)
%
Y  = 0.07;
E  = 1./Y;
%
% steady state biomass
%
bioMass = (uu-rG)./E
%
% rate parameters estimated from modeling
%
F = (vv-rA)./bioMass

