function [ dSdt ] = chemostat_2nutrient_dynamics_Part2(t,S,params)
% this function defines the chemostat differential equation
%
% get the individual parameters from the vector
%
q    = params(1);
u    = params(2);
v    = params(3);
ep   = params(4);
fp   = params(5);
r    = params(6);
K    = params(7);
L    = params(8);
%
% initialize the state's derivative
%
dSdt = zeros(size(S));
%
% put things in terms of individual variables
%
x = S(1); % cells
y = S(2); % food
z = S(3);
%
% form the differential equation formulae
%
ry    = r*(y/(K+y))*(z/(L+z)); %r*(z*y)/((K+y)*(L+z));%
dxdt  = (ry)*x - q*x;
dydt  = q*(u - y) - (.7012*y+14.2478)*ry*x;
dzdt  = q*(v - z) - fp*ry*x;
%
% put things back in terms of state vector variable
%
dSdt(1) = dxdt;
dSdt(2) = dydt;
dSdt(3) = dzdt;
end