/*
 * Decompiled with CFR 0.152.
 */
package goslim;

import goslim.CluAnno;
import goslim.CluFCM;
import goslim.CluGOOnto;
import goslim.CluGOSlimHier;
import goslim.CluGeneExpList;
import goslim.CluHierBuild;
import java.util.ArrayList;
import scripts.CluMemberDistrib;

public class CluFCMMainyeastall {
    static String aspect = "P";
    static String ignoreFilename = "ignoreGOTerms.txt";
    static String goAnnoFilename = "./annotation/gene_association.sgd-Sep05";
    static String evidCodeFilename = "./annotation/evidence_code.txt";
    static String goSlimFilename = "./go_files/goslim_yeast.obo";
    static String mapFilename = "./annotation/uniprotmapping.txt";
    static String geneExpFilename = "yeastall_public.txt";
    static String subset = "goslim_yeast";
    static String category = "biological_process";
    static int numInstances = 6221;
    static int numSamples = 80;
    static String testFilename = "test-eisen.txt";
    static String outFilename = "./yeastall_public/" + geneExpFilename + "_alpha0.2";
    static double alpha = 0.2;
    static double threshold = 0.05;
    static double minMemValue = 0.2;
    static double ratio = 0.25;
    static int numRepetition = 30;

    public void run(CluAnno cluAnno, int n) {
        CluGeneExpList cluGeneExpList = new CluGeneExpList(cluAnno, numInstances, numSamples);
        cluGeneExpList.readGeneExpFile("./data/" + geneExpFilename);
        cluGeneExpList.sampleGenes(outFilename + "-" + n + ".txt", 1.0 - ratio);
        CluFCM cluFCM = new CluFCM(cluGeneExpList, outFilename + "-" + n + ".txt", evidCodeFilename);
        cluFCM.initializeU_eviCode(alpha, minMemValue);
        int n2 = 20;
        for (int i = 0; i < n2; ++i) {
            System.out.println("-----");
            cluFCM.computeCentroids();
            cluFCM.computeMembershipWithGO();
            cluFCM.computeValidity();
            cluFCM.nextStep();
            System.out.println("Iteration " + i + " is complete.");
        }
        cluFCM.printOptimal();
        cluFCM.printOptimalClusterGene(outFilename + "-multiple-" + n + ".txt", threshold);
        cluFCM.done();
        CluMemberDistrib cluMemberDistrib = new CluMemberDistrib();
        cluMemberDistrib.readInitMembers(outFilename + "-" + n + ".txt");
        cluMemberDistrib.readMultiMembers(outFilename + "-multiple-" + n + ".txt");
        cluMemberDistrib.countNumClusters();
        cluMemberDistrib.writeStat(outFilename + "-stat-" + n + ".txt");
    }

    public static void main(String[] stringArray) {
        System.out.println("-- Build GO --");
        CluGOOnto cluGOOnto = new CluGOOnto("./go_files/go_200509-termdb-tables/");
        ArrayList arrayList = cluGOOnto.getGOTerms();
        int n = cluGOOnto.getIndex("GO:0008150");
        System.out.println("-- Build GO Slim Hierarchy --");
        CluGOSlimHier cluGOSlimHier = new CluGOSlimHier(goSlimFilename, subset, category);
        cluGOSlimHier.buildHier();
        System.out.println("-- Done Building GO Slim Hierarchy --");
        ArrayList arrayList2 = cluGOSlimHier.getTermsWithParent();
        CluHierBuild cluHierBuild = new CluHierBuild(arrayList, arrayList2);
        cluHierBuild.generateSlim(n, 0);
        CluAnno cluAnno = new CluAnno(aspect, cluGOOnto);
        cluAnno.read(goAnnoFilename);
        CluFCMMainyeastall cluFCMMainyeastall = new CluFCMMainyeastall();
        for (int i = 0; i < numRepetition; ++i) {
            System.out.println("== Run iteration " + i + "==");
            cluFCMMainyeastall.run(cluAnno, i);
        }
    }
}

