/*
 * Decompiled with CFR 0.152.
 */
package goslim;

import goslim.CluAnno;
import goslim.CluFCM;
import goslim.CluGOOnto;
import goslim.CluGOSlimHier;
import goslim.CluGeneExpList;
import goslim.CluHierBuild;
import goslim.CluUniProtMap;
import java.util.ArrayList;
import scripts.CluMemberDistrib;

public class CluFCMDriver {
    static String aspect = "P,C,F";
    static String ignoreFilename = "ignoreGOTerms.txt";
    static String goAnnoFilename;
    static String goAnnoHumanFilename;
    static String goAnnoYeastFilename;
    static String evidCodeFilename;
    static String mapFilename;
    static String geneExpFilename;
    static String goSlimFilename;
    static String goSlimYeastFilename;
    static String goSlimHumanFilename;
    static String subset;
    static String subsetYeast;
    static String subsetHuman;
    static String category;
    static String taxonID;
    static int numInstances;
    static int numSamples;
    static String outFilename;
    static double alpha;
    static double threshold;
    static double minMemValue;
    boolean readCDT;
    static CluUniProtMap upm;

    public CluFCMDriver(boolean bl) {
        this.readCDT = bl;
    }

    public void run(CluAnno cluAnno, String string) {
        geneExpFilename = string;
        outFilename = "out-" + string;
        CluGeneExpList cluGeneExpList = new CluGeneExpList(cluAnno, numInstances, numSamples);
        if (this.readCDT) {
            cluGeneExpList.readGeneExpCDTFile(string);
        } else {
            cluGeneExpList.readGeneExpFile(string);
        }
        CluFCM cluFCM = new CluFCM(cluGeneExpList, outFilename, evidCodeFilename);
        cluFCM.initializeU_eviCode(alpha, minMemValue);
        int n = 20;
        for (int i = 0; i < n; ++i) {
            System.out.println("-----");
            cluFCM.computeCentroids();
            cluFCM.computeMembershipWithGO();
            cluFCM.computeValidity();
            cluFCM.nextStep();
            System.out.println("Iteration " + i + " is complete.");
        }
        cluFCM.printOptimal();
        cluFCM.printOptimalClusterGene("multiple-" + outFilename, threshold);
        cluFCM.done();
        CluMemberDistrib cluMemberDistrib = new CluMemberDistrib();
        cluMemberDistrib.readInitMembers(outFilename);
        cluMemberDistrib.readMultiMembers("multiple-" + outFilename);
        cluMemberDistrib.countNumClusters();
        cluMemberDistrib.writeStat("stat-" + outFilename);
    }

    public static void main(String[] stringArray) {
        goAnnoYeastFilename = goAnnoYeastFilename + stringArray[4];
        if (stringArray.length >= 4) {
            boolean bl = false;
            String string = stringArray[0];
            taxonID = stringArray[1];
            String string2 = stringArray[2];
            String string3 = stringArray[3];
            if (stringArray.length > 4 && stringArray[4].equals("-cdt")) {
                bl = true;
            }
            numInstances = new Integer(string2);
            numSamples = new Integer(string3);
            if (taxonID.equals("9606")) {
                subset = subsetHuman;
                goAnnoFilename = goAnnoHumanFilename;
                goSlimFilename = goSlimHumanFilename;
            }
            if (taxonID.equals("4932")) {
                subset = subsetYeast;
                goAnnoFilename = goAnnoYeastFilename;
                goSlimFilename = goSlimYeastFilename;
            }
            System.out.println("-- Build GO --");
            CluGOOnto cluGOOnto = new CluGOOnto("./go_files/go_200509-termdb-tables/");
            ArrayList arrayList = cluGOOnto.getGOTerms();
            int n = cluGOOnto.getIndex("all");
            System.out.println("-- Build GO Slim Hierarchy --");
            CluGOSlimHier cluGOSlimHier = new CluGOSlimHier(goSlimFilename, subset, category);
            cluGOSlimHier.buildHier();
            System.out.println("-- Done Building GO Slim Hierarchy --");
            ArrayList arrayList2 = cluGOSlimHier.getTermsWithParent();
            CluHierBuild cluHierBuild = new CluHierBuild(arrayList, arrayList2);
            cluHierBuild.generateSlim(n, 0);
            CluAnno cluAnno = new CluAnno(aspect, cluGOOnto);
            cluAnno.read(goAnnoFilename);
            upm = new CluUniProtMap(mapFilename);
            upm.read();
            CluFCMDriver cluFCMDriver = new CluFCMDriver(bl);
            cluFCMDriver.run(cluAnno, string);
        } else {
            System.out.println("Usage: gene_exp_file taxonID numGenes numSamples [-cdt]");
            System.exit(0);
        }
    }

    static {
        goAnnoHumanFilename = "./annotation/gene_association.goa_human";
        goAnnoYeastFilename = "./annotation/gene_association.";
        evidCodeFilename = "./annotation/evidence_code.txt";
        mapFilename = "./annotation/uniprotmapping.txt";
        goSlimYeastFilename = "./go_files/goslim_yeast.obo";
        goSlimHumanFilename = "./go_files/goslim_generic.obo";
        subsetYeast = "goslim_yeast";
        subsetHuman = "goslim_generic";
        category = "biological_process,cellular_component,molecular_function";
        outFilename = "out-" + geneExpFilename;
        alpha = 0.3;
        threshold = 0.05;
        minMemValue = 0.2;
    }
}

