/*
 * Decompiled with CFR 0.152.
 */
package goslim;

import goslim.CluGeneExpList;
import goslim.CluGeneInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class CluFCM {
    int numInstances;
    int numClusters;
    int numSamples;
    double[][] x;
    double[][] origU;
    double[][] U_k;
    double[][] U_k_prime;
    double[][] U_k_optimal;
    double[][] c_k;
    double[][] c_k_prime;
    double[][] c_k_optimal;
    Hashtable<Double, ArrayList<Integer>> clusterMembership;
    double sOptimal = 1000.0;
    int kIteration = 0;
    int stepOptimal = 0;
    ArrayList goClusters = new ArrayList();
    ArrayList geneNames = new ArrayList();
    ArrayList geneNamesDesc = new ArrayList();
    CluGeneExpList gel;
    PrintWriter pw;
    Hashtable evidCodeProb = new Hashtable();
    Hashtable<String, ArrayList<String>> optimalHardCluster;

    public CluFCM(CluGeneExpList cluGeneExpList, String string, String string2) {
        this.gel = cluGeneExpList;
        this.x = cluGeneExpList.geneExp();
        this.numClusters = cluGeneExpList.getNumMappedClusters();
        this.numInstances = cluGeneExpList.getNumInstances();
        this.numSamples = cluGeneExpList.getNumSamples();
        this.geneNames = cluGeneExpList.getGeneNames();
        this.geneNamesDesc = cluGeneExpList.getGeneNamesDesc();
        try {
            PrintWriter printWriter;
            FileWriter fileWriter = new FileWriter(string);
            this.pw = printWriter = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.readEvidCode(string2);
    }

    private void readEvidCode(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = new String();
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\t");
                this.evidCodeProb.put(stringArray[0], new Double(stringArray[1]));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void initializeU(double d) {
        int n;
        int n2;
        Object object;
        int n3;
        Object object2;
        System.out.println("Initializing....");
        this.goClusters = new ArrayList();
        Hashtable hashtable = this.gel.getGOCluster();
        Enumeration enumeration = hashtable.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(object2);
            this.goClusters.add(object2);
        }
        this.numClusters = hashtable.size();
        System.out.println("Number of clusters after filtering: " + this.numClusters);
        this.origU = new double[this.numInstances][this.numClusters];
        this.U_k = new double[this.numInstances][this.numClusters];
        this.U_k_prime = new double[this.numInstances][this.numClusters];
        this.U_k_optimal = new double[this.numInstances][this.numClusters];
        this.c_k = new double[this.numClusters][this.numSamples];
        this.c_k_prime = new double[this.numClusters][this.numSamples];
        this.c_k_optimal = new double[this.numClusters][this.numSamples];
        object2 = new Hashtable();
        for (n3 = 0; n3 < this.goClusters.size(); ++n3) {
            String string = (String)this.goClusters.get(n3);
            object = (ArrayList)hashtable.get(string);
            this.pw.println();
            this.pw.println(string + " " + ((ArrayList)object).size());
            for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                CluGeneInfo cluGeneInfo = (CluGeneInfo)((ArrayList)object).get(n2);
                this.pw.print(cluGeneInfo + " ");
                int n4 = cluGeneInfo.numBelongsTo();
                ((Hashtable)object2).put(cluGeneInfo.getOfficialName(), new Integer(n4));
                n = this.geneNames.indexOf(cluGeneInfo.getOfficialName());
                this.origU[n][n3] = 1.0 / ((double)n4 * 1.0);
                this.U_k[n][n3] = 1.0 / ((double)n4 * 1.0);
            }
            System.out.println();
            this.pw.println();
        }
        System.out.println("Number of mapped genes: " + ((Hashtable)object2).size());
        n3 = 0;
        for (int i = 0; i < this.numInstances; ++i) {
            int n5;
            object = (String)this.geneNames.get(i);
            n2 = 0;
            double d2 = 1.0;
            if (((Hashtable)object2).containsKey(object)) {
                Integer n6 = (Integer)((Hashtable)object2).get(object);
                n2 = n6;
                d2 = 1.0 / ((double)n2 * 1.0);
            }
            n = 0;
            double d3 = 0.0;
            for (n5 = 0; n5 < this.numClusters; ++n5) {
                if (this.origU[i][n5] == 0.0) {
                    if (n2 == 0) {
                        this.origU[i][n5] = 1.0 / ((double)this.numClusters * 1.0);
                        this.U_k[i][n5] = 1.0 / ((double)this.numClusters * 1.0);
                    } else {
                        n = 1;
                        this.origU[i][n5] = d * d2;
                        this.U_k[i][n5] = d * d2;
                    }
                }
                d3 += this.origU[i][n5];
            }
            if (n != 0) {
                ++n3;
            }
            for (n5 = 0; n5 < this.numClusters; ++n5) {
                this.origU[i][n5] = this.origU[i][n5] / (d3 * 1.0);
                this.U_k[i][n5] = this.U_k[i][n5] / (d3 * 1.0);
            }
        }
        System.out.println("Number of genes with annotations = " + n3);
    }

    public void initializeU_eviCode(double d, double d2) {
        int n;
        Object object;
        System.out.println("Initializing....");
        this.goClusters = new ArrayList();
        Hashtable hashtable = this.gel.getGOCluster();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.goClusters.add(object);
        }
        this.numClusters = hashtable.size();
        System.out.println("Number of clusters: " + this.numClusters);
        this.origU = new double[this.numInstances][this.numClusters];
        this.U_k = new double[this.numInstances][this.numClusters];
        this.U_k_prime = new double[this.numInstances][this.numClusters];
        this.U_k_optimal = new double[this.numInstances][this.numClusters];
        this.c_k = new double[this.numClusters][this.numSamples];
        this.c_k_prime = new double[this.numClusters][this.numSamples];
        this.c_k_optimal = new double[this.numClusters][this.numSamples];
        object = new Hashtable();
        for (n = 0; n < this.numInstances; ++n) {
            for (int i = 0; i < this.numClusters; ++i) {
                this.origU[n][i] = d * d2;
                this.U_k[n][i] = d * d2;
            }
        }
        for (n = 0; n < this.goClusters.size(); ++n) {
            String string = (String)this.goClusters.get(n);
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            this.pw.println();
            this.pw.println(string + " " + arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                CluGeneInfo cluGeneInfo = (CluGeneInfo)arrayList.get(i);
                this.pw.print(cluGeneInfo + " ");
                int n2 = cluGeneInfo.numBelongsTo();
                ArrayList arrayList2 = cluGeneInfo.getEviCodes(string);
                double d3 = 0.0;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    String string2 = (String)arrayList2.get(j);
                    Double d4 = (Double)this.evidCodeProb.get(string2);
                    if (!(d4 > d3)) continue;
                    d3 = d4;
                }
                double d5 = d3;
                ((Hashtable)object).put(cluGeneInfo.getOfficialName(), new Integer(n2));
                int n3 = this.geneNames.indexOf(cluGeneInfo.getOfficialName());
                this.origU[n3][n] = d5 - d * (d5 - d2);
                this.U_k[n3][n] = d5 - d * (d5 - d2);
            }
            this.pw.println();
        }
        this.pw.println("Number of mapped genes: " + ((Hashtable)object).size());
    }

    public void initializeU_rand(int n) {
        this.numClusters = n;
        this.origU = new double[this.numInstances][this.numClusters];
        this.U_k = new double[this.numInstances][this.numClusters];
        this.U_k_prime = new double[this.numInstances][this.numClusters];
        this.U_k_optimal = new double[this.numInstances][this.numClusters];
        this.c_k = new double[this.numClusters][this.numSamples];
        this.c_k_prime = new double[this.numClusters][this.numSamples];
        this.c_k_optimal = new double[this.numClusters][this.numSamples];
        System.out.println("==== Random Initialization ====");
        NumberFormat numberFormat = NumberFormat.getInstance();
        Random random = new Random();
        for (int i = 0; i < this.numInstances; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.numClusters; ++j) {
                double d2;
                this.origU[i][j] = d2 = random.nextDouble();
                this.U_k[i][j] = d2;
                d += d2;
            }
        }
    }

    public void computeCentroids() {
        for (int i = 0; i < this.numClusters; ++i) {
            for (int j = 0; j < this.numSamples; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                for (int k = 0; k < this.numInstances; ++k) {
                    double d3 = this.U_k[k][i] * this.U_k[k][i];
                    d += d3;
                    d2 += d3 * this.x[k][j];
                }
                this.c_k_prime[i][j] = d2 / d;
            }
        }
    }

    public void computeMembership() {
        for (int i = 0; i < this.numInstances; ++i) {
            for (int j = 0; j < this.numClusters; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.numSamples; ++k) {
                    d += (this.x[i][k] - this.c_k_prime[j][k]) * (this.x[i][k] - this.c_k_prime[j][k]);
                }
                d = 1.0 / Math.sqrt(d);
                double d2 = 0.0;
                for (int k = 0; k < this.numClusters; ++k) {
                    double d3 = 0.0;
                    for (int i2 = 0; i2 < this.numSamples; ++i2) {
                        d3 += (this.x[i][i2] - this.c_k_prime[k][i2]) * (this.x[i][i2] - this.c_k_prime[k][i2]);
                    }
                    d2 += d3;
                }
                d2 = 1.0 / Math.sqrt(d2);
                this.U_k_prime[i][j] = d / d2;
            }
        }
    }

    public void computeMembershipWithGO() {
        int n;
        this.computeMembership();
        for (n = 0; n < this.numInstances; ++n) {
            for (int i = 0; i < this.numClusters; ++i) {
                double[] dArray = this.U_k_prime[n];
                int n2 = i;
                dArray[n2] = dArray[n2] * this.origU[n][i];
            }
        }
        for (n = 0; n < this.numInstances; ++n) {
            int n3;
            double d = 0.0;
            for (n3 = 0; n3 < this.numClusters; ++n3) {
                d += this.U_k_prime[n][n3];
            }
            for (n3 = 0; n3 < this.numClusters; ++n3) {
                double[] dArray = this.U_k_prime[n];
                int n4 = n3;
                dArray[n4] = dArray[n4] / d;
                if (!Double.isNaN(this.U_k_prime[n][n3])) continue;
                this.U_k_prime[n][n3] = 0.0;
            }
        }
    }

    public void computeValidity() {
        double d;
        int n;
        double[] dArray = new double[this.numClusters];
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.numClusters; ++i) {
            double d4 = 0.0;
            for (n = 0; n < this.numInstances; ++n) {
                d = this.U_k_prime[n][i] * this.U_k_prime[n][i];
                double d5 = 0.0;
                for (int j = 0; j < this.numSamples; ++j) {
                    d5 += (this.x[n][j] - this.c_k_prime[i][j]) * (this.x[n][j] - this.c_k_prime[i][j]);
                }
                d4 += d * d5;
            }
            dArray[i] = d4;
            d2 += d4;
        }
        double d6 = 1000.0;
        for (int i = 0; i < this.numClusters; ++i) {
            for (n = i + 1; n < this.numClusters; ++n) {
                d = 0.0;
                for (int j = 0; j < this.numSamples; ++j) {
                    d += (this.c_k_prime[i][j] - this.c_k_prime[n][j]) * (this.c_k_prime[i][j] - this.c_k_prime[n][j]);
                }
                if (!(d < d6)) continue;
                d6 = d;
            }
        }
        d3 = (double)this.numInstances * d6;
        double d7 = d2 / d3;
        System.out.println(d7 + " " + this.sOptimal);
        this.pw.println(d7 + " " + this.sOptimal);
        this.pw.println("Iteration " + this.kIteration + " is complete....");
        this.pw.println();
        if (d7 < this.sOptimal || this.kIteration == 0) {
            int n2;
            this.sOptimal = d7;
            this.stepOptimal = this.kIteration;
            for (n2 = 0; n2 < this.numClusters; ++n2) {
                this.c_k_optimal[n2] = this.c_k_prime[n2];
            }
            for (n2 = 0; n2 < this.numInstances; ++n2) {
                this.U_k_optimal[n2] = this.U_k_prime[n2];
            }
        }
    }

    public void nextStep() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numClusters; ++n2) {
            for (n = 0; n < this.numSamples; ++n) {
                this.c_k[n2][n] = this.c_k_prime[n2][n];
            }
        }
        for (n2 = 0; n2 < this.numInstances; ++n2) {
            for (n = 0; n < this.numClusters; ++n) {
                this.U_k[n2][n] = this.U_k_prime[n2][n];
            }
        }
        ++this.kIteration;
    }

    public void printResults() {
        int n;
        int n2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        System.out.println("Centroids");
        for (n2 = 0; n2 < this.numClusters; ++n2) {
            System.out.print("   Cluster " + n2 + ": ");
            for (n = 0; n < this.numSamples; ++n) {
                System.out.print(numberFormat.format(this.c_k[n2][n]) + "\t");
            }
            System.out.println();
        }
        System.out.println("Memberships");
        for (n2 = 0; n2 < this.numInstances; ++n2) {
            System.out.print("   Instance " + n2 + ": ");
            for (n = 0; n < this.numClusters; ++n) {
                System.out.print(numberFormat.format(this.U_k[n2][n]) + "\t");
            }
            System.out.println();
        }
    }

    public void printOptimal() {
        int n;
        NumberFormat numberFormat = NumberFormat.getInstance();
        this.pw.println("Centroids");
        for (n = 0; n < this.numClusters; ++n) {
            this.pw.print("   Cluster " + n + ": ");
            for (int i = 0; i < this.numSamples; ++i) {
                this.pw.print(numberFormat.format(this.c_k_optimal[n][i]) + "\t");
            }
            this.pw.println();
        }
        System.out.println("Memberships");
        for (n = 0; n < this.numInstances; ++n) {
            String string = (String)this.geneNames.get(n);
            this.pw.print("   " + string + "\t");
            for (int i = 0; i < this.numClusters; ++i) {
                this.pw.print(numberFormat.format(this.U_k_optimal[n][i]) + "\t");
            }
            this.pw.println();
        }
        this.pw.println("Reaches optimal cluster at iteration " + this.stepOptimal);
    }

    public ArrayList<Integer> getMergedClusterMembers(int n) {
        Enumeration<ArrayList<Integer>> enumeration = this.clusterMembership.elements();
        int n2 = -1;
        ArrayList<Integer> arrayList = null;
        while (enumeration.hasMoreElements() && n2 != n) {
            if (++n2 == n) {
                arrayList = enumeration.nextElement();
                continue;
            }
            enumeration.nextElement();
        }
        return arrayList;
    }

    public void printOptimalClusterGene() {
        String string;
        int n;
        this.pw.println("Hard clustering results.....");
        Hashtable hashtable = new Hashtable();
        for (n = 0; n < this.goClusters.size(); ++n) {
            string = (String)this.goClusters.get(n);
            hashtable.put(string, new ArrayList());
        }
        for (n = 0; n < this.numInstances; ++n) {
            string = (String)this.geneNames.get(n);
            double d = 0.0;
            int n2 = -1;
            for (int i = 0; i < this.numClusters; ++i) {
                if (!(this.U_k_optimal[n][i] > d)) continue;
                n2 = i;
                d = this.U_k_optimal[n][i];
            }
            if (n2 <= -1) continue;
            String string2 = (String)this.goClusters.get(n2);
            ArrayList arrayList = (ArrayList)hashtable.get(string2);
            arrayList.add(string);
        }
        for (n = 0; n < this.goClusters.size(); ++n) {
            string = (String)this.goClusters.get(n);
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            this.pw.println();
            this.pw.println(string + "[#Members=" + arrayList.size() + "]: ");
            for (int i = 0; i < arrayList.size(); ++i) {
                this.pw.print((String)arrayList.get(i) + " ");
            }
            this.pw.println();
        }
    }

    public void printOptimalClusterGene(String string, double d) {
        try {
            Object object;
            String string2;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("Clustering results for memberships above " + d + " [" + this.sOptimal + "]");
            this.optimalHardCluster = new Hashtable();
            Hashtable hashtable = new Hashtable();
            for (int i = 0; i < this.goClusters.size(); ++i) {
                String string3 = (String)this.goClusters.get(i);
                this.optimalHardCluster.put(string3, new ArrayList());
                hashtable.put(string3, new ArrayList());
            }
            NumberFormat numberFormat = NumberFormat.getInstance();
            for (n = 0; n < this.numInstances; ++n) {
                string2 = (String)this.geneNames.get(n);
                for (int i = 0; i < this.numClusters; ++i) {
                    if (!(this.U_k_optimal[n][i] > d)) continue;
                    object = (String)this.goClusters.get(i);
                    ArrayList<String> arrayList = this.optimalHardCluster.get(object);
                    ArrayList arrayList2 = (ArrayList)hashtable.get(object);
                    arrayList.add(string2);
                    arrayList2.add(numberFormat.format(this.U_k_optimal[n][i]));
                }
            }
            for (n = 0; n < this.goClusters.size(); ++n) {
                string2 = (String)this.goClusters.get(n);
                ArrayList<String> arrayList = this.optimalHardCluster.get(string2);
                object = (ArrayList)hashtable.get(string2);
                printWriter.println();
                printWriter.println(string2 + "[#Members=" + arrayList.size() + "]: ");
                for (int i = 0; i < arrayList.size(); ++i) {
                    printWriter.print(arrayList.get(i) + " " + (String)((ArrayList)object).get(i) + "\t");
                }
                printWriter.println();
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public Hashtable getOptimalCluster() {
        return this.optimalHardCluster;
    }

    public void outputMapleTreeFormat(String string) {
        String[] stringArray = this.gel.getColumnHeaders();
        int n = this.gel.getExpStartCol();
        try {
            int n2;
            int n3;
            FileWriter fileWriter = new FileWriter(string + "_finalcentroids.fct");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print("UID\tNAME\tGWEIGHT");
            for (n3 = n; n3 < stringArray.length; ++n3) {
                printWriter.print("\t" + stringArray[n3]);
            }
            printWriter.println();
            for (n3 = 0; n3 < this.numClusters; ++n3) {
                printWriter.print(n3 + "\t" + "Node " + n3 + "\t" + "1");
                for (int i = 0; i < this.numSamples; ++i) {
                    if (stringArray[n + i].length() > 0) {
                        printWriter.print("\t" + this.c_k_optimal[n3][i]);
                        continue;
                    }
                    printWriter.print("\t0");
                }
                printWriter.println();
            }
            printWriter.close();
            FileWriter fileWriter2 = new FileWriter(string + "_finalmemberships.mb");
            PrintWriter printWriter2 = new PrintWriter(fileWriter2);
            printWriter2.print("UID\tNAME\tGWEIGHT");
            for (n2 = 0; n2 < this.numClusters; ++n2) {
                printWriter2.print("\tNode " + n2);
            }
            printWriter2.println();
            for (n2 = 0; n2 < this.numInstances; ++n2) {
                String string2;
                String string3 = (String)this.geneNamesDesc.get(n2);
                int n4 = string3.indexOf(" ");
                if (n4 == -1) {
                    n4 = string3.length();
                }
                if ((string2 = string3.substring(0, n4)).indexOf("\"") == 0) {
                    string2 = string2.substring(1);
                }
                printWriter2.print(string2 + "\t" + string3 + "\t" + "1");
                for (int i = 0; i < this.numClusters; ++i) {
                    printWriter2.print("\t" + this.U_k_optimal[n2][i]);
                }
                printWriter2.println();
            }
            printWriter2.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void done() {
        this.pw.close();
    }
}

