#This code describes how to perform within array normalization and between  
#array normalization for Ontario chips.

#Load limma.
library(limma)

#Set the directory to where all the Ontario chip GPR files are located.
#Read the targets file for the Ontario chips.
Otargets<-read.csv(file.choose())

#Read in the GPR files by designating the column within the targets file 
#that has the list of GPR files.
f<-function(x) as.numeric(x$Flags > -99)
RGO<-read.maimages(Otargets$FileName, source="genepix.median", wt.fun=f)

#Extract the column of values from the targets file that indicates which 
#chips were dye-swapped.
ds<-Otargets$Dyeswap

#Within Array Normalization
MAO<-normalizeWithinArrays(RGO, method="loess", bc.method="normexp")

#Create a list of the names of the genes on the chip.
M1<-tapply(MAO$M[,1],as.factor(MAO$genes$Name),mean)
ontID<-rownames(M1)

#Designate which column of the targets file contains the name of each chip in
#the form <strain>_LogFC_t<time point>-<flask number>.
headers<-Otargets$Header

#Create a matrix MO to store the data after replicates have been averaged.
n0<-length(MAO$M[1,])
n1<-length(M1)
MO<-matrix(nrow=n1,ncol=n0)

#Set up a for loop to average replicates and store the data in matrix MO.
for(i in 1:n0) {MO[,i]<-tapply(MAO$M[,i],as.factor(MAO$genes$Name),mean)}

#Create a new matrix MD to store the data.
MD<-matrix(nrow=n1,ncol=n0)

#Set up a for loop to multiply each row of the data matrix MO by the vector of
#values ds indicating the dye-swapped chips. Store the output to the matrix MD.
for(i in 1:n0) {MD[,i]<-ds[i]*MO[,i]}

#Convert matrix MD to a data frame. The row names of the data frame should
#be the names of the genes on the Ontario chips. The column names of the
#data frame should be the names of each chip that include the strain, time 
#point and flask number.
MD2<-as.data.frame.matrix(MD)
colnames(MD2)<-headers
rownames(MD2)<-ontID

#Get rid of the controls (Arabidopsis and 3XSSC).
MD3<-subset(MD2,row.names(MD2)!="Arabidopsis")
MD4<-subset(MD3,row.names(MD3)!="3XSSC")

#If normalizing both GCAT and Ontario chip data,
#make sure the directory is set to where all the GCAT chip GPR files are located.
#Go to the code GCAT_and_Ontario_Chip_Normalization.R.

#If normalizing only Ontario chip data, go to the code
#Between_Array_Normalization_Ontario_Only.R






