<?php
# Example WikiMedia extension
# with WikiMedia's extension mechanism it is possible to define
# new tags of the form
# <TAGNAME> some text </TAGNAME>
# the function registered by the extension gets the text between the
# tags as input and can transform it into arbitrary HTML code.
# Note: The output is not interpreted as WikiText but directly
#       included in the HTML output. So Wiki markup is not supported.
# To activate the extension, include it from your LocalSettings.php
# with: include("extensions/YourExtensionName.php");

$wgExtensionFunctions[] = "wfx3dExtension";

function wfx3dExtension() {
    global $wgParser;
    # register the extension with the WikiText parser
    # the first parameter is the name of the new tag.
    # In this case it defines the tag <x3d> ... </x3d>
    # the second parameter is the callback function for
    # processing the text between the tags
    $wgParser->setHook( "x3d", "renderx3d" );
}

# The callback function for converting the input text to HTML output
function renderx3d( $input, $argv = null ) {
    # $argv is an array containing any arguments passed to the
    # extension like <example argument="foo" bar>..

$width = 320;
$height = 320;
$focal = 0;
$zoom = 0;
$N = 0;

if ($argv && $argv["width"]) {
        $width = $argv["width"];
}

if ($argv && $argv["height"]) {
        $height = $argv["height"];
}

if ($argv && $argv["focal"]) {
        $focal = $argv["focal"];
}

if ($argv && $argv["zoom"]) {
        $zoom = $argv["zoom"];
}

if ($argv && $argv["N"]) {
        $N = $argv["N"];
}

$i = 0;
$l = strlen($input);
$last = " ";
$model = "";

while ($i < $l) {
        $char = $input[$i];
        if ($char == " " || $char == "\t" || $char == "\n" || $char == "\r") {
                if ($last != " ") {
                        $model .= " ";
                }
                $last = " " ;
        }
        else {
                if ($char == "\"" || $char == "'") {
                        if ($last != "'") {
                                $model .= "'";
                        }
                        $last = "'";
                }
                else {
                        $model .= $char;
                        $last = $char;
                }
        }
        $i++;
}


$output  = "<applet code=\"org.yriarte.x3d.X3dApplet.class\" " ;
$output .= " width=\"$width\" height=\"$height\" " ;
$output .= " archive=\"" . $GLOBALS["wgScriptPath"] . "/extensions/x3d/x3d.jar\">" ;
if ($focal != 0) {
	$output .= "\n" . "<param name=\"focal\" value=\"" . "$focal" . "\">" ; 
}
if ($zoom != 0) {
	$output .= "\n" . "<param name=\"zoom\" value=\"" . "$zoom" . "\">" ;
}
if ($N != 0) {
	$output .= "\n" . "<param name=\"N\" value=\"" . "$N" . "\">" ;
}
$output .= "\n" . "<param name=\"scene\" value=\"" . "<X3D>" . $model . "</X3D>" . "\">" ;
$output .= "\n" . "</applet>" ;

    return $output;
}

?>