/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.x3d;

import java.awt.Component;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.InputStream;
import org.json.JSONObject;
import org.json.XML;
import org.yriarte.mini3D.Mini3DPanel;
import org.yriarte.mini3D.Object3D;
import org.yriarte.x3d.JSONx3dFactory;

public class X3dFileReader {
    static int BUFSIZE = 4096;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("No x3d file to open, exiting");
            return;
        }
        try {
            int nb;
            FileInputStream is = new FileInputStream(args[0]);
            byte[] buffer = new byte[BUFSIZE];
            String str = "";
            while ((nb = ((InputStream)is).read(buffer)) > 0) {
                str = String.valueOf(str) + new String(buffer, 0, nb);
            }
            JSONObject jobj = XML.toJSONObject(str);
            Object3D scene = JSONx3dFactory.getScene(jobj);
            Frame frm = new Frame();
            ((Component)frm).setSize(600, 600);
            frm.setTitle(args[0]);
            Mini3DPanel pnl = new Mini3DPanel();
            frm.add(pnl);
            frm.show();
            pnl.init(scene);
            frm.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

