/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.x3d;

import java.awt.Color;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.yriarte.mini3D.Box;
import org.yriarte.mini3D.Matrix3D;
import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Object3D;
import org.yriarte.mini3D.PolyCone;
import org.yriarte.mini3D.PolyCylinder;
import org.yriarte.mini3D.PolySphere;
import org.yriarte.mini3D.Vector3D;

public class JSONx3dFactory {
    static HashMap defs = new HashMap();

    static void defKey(JSONObject jObj) {
        try {
            String key = jObj.getString("DEF");
            defs.put(key, jObj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static JSONObject useKey(JSONObject jObj) {
        JSONObject jUse = null;
        try {
            String key = jObj.getString("USE");
            jUse = (JSONObject)defs.get(key);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jUse == null ? jObj : jUse;
    }

    static Object3D getObject3D(JSONObject aTransformGroup) {
        JSONx3dFactory.defKey(aTransformGroup);
        aTransformGroup = JSONx3dFactory.useKey(aTransformGroup);
        Object3D obj = null;
        try {
            JSONObject aShape = aTransformGroup.getJSONObject("Shape");
            obj = JSONx3dFactory.getShape(aShape);
            obj.setColor(JSONx3dFactory.getColor(aShape));
        }
        catch (JSONException e) {
            try {
                JSONArray jShapes = aTransformGroup.getJSONArray("Shape");
                obj = JSONx3dFactory.getShape(jShapes.getJSONObject(0));
                obj.setColor(JSONx3dFactory.getColor(jShapes.getJSONObject(0)));
                int i = 1;
                while (i < jShapes.length()) {
                    Object3D child = JSONx3dFactory.getShape(jShapes.getJSONObject(i));
                    child.setColor(JSONx3dFactory.getColor(jShapes.getJSONObject(i)));
                    obj.addChild(child);
                    ++i;
                }
            }
            catch (JSONException e1) {
                obj = new Object3D();
            }
        }
        obj.setPosition(JSONx3dFactory.getTranslation(aTransformGroup));
        obj.setOrientation(JSONx3dFactory.getRotation(aTransformGroup));
        Matrix3D scale = JSONx3dFactory.getScale(aTransformGroup);
        String[] tags = new String[]{"Transform", "Group"};
        int s = 0;
        while (s < tags.length) {
            try {
                JSONArray jObjects = aTransformGroup.getJSONArray(tags[s]);
                int i = 0;
                while (i < jObjects.length()) {
                    obj.addChild(JSONx3dFactory.getObject3D(jObjects.getJSONObject(i)));
                    ++i;
                }
            }
            catch (JSONException e) {
                try {
                    obj.addChild(JSONx3dFactory.getObject3D(aTransformGroup.getJSONObject(tags[s])));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            ++s;
        }
        if (!scale.isId()) {
            System.out.println("Scale: " + scale.toString());
            obj.transformMeshes(scale);
        }
        return obj;
    }

    static Object3D getShape(JSONObject aShape) {
        JSONx3dFactory.defKey(aShape);
        aShape = JSONx3dFactory.useKey(aShape);
        Object3D obj = null;
        try {
            double r;
            double h;
            aShape.getJSONObject("Cone");
            try {
                h = aShape.getJSONObject("Cone").getDouble("height");
            }
            catch (JSONException e) {
                h = 1.0;
            }
            try {
                r = aShape.getJSONObject("Cone").getDouble("bottomRadius");
            }
            catch (JSONException e) {
                r = 1.0;
            }
            obj = new PolyCone(h, r);
        }
        catch (JSONException eCone) {
            try {
                double r;
                double h;
                aShape.getJSONObject("Cylinder");
                try {
                    h = aShape.getJSONObject("Cylinder").getDouble("height");
                }
                catch (JSONException e) {
                    h = 1.0;
                }
                try {
                    r = aShape.getJSONObject("Cylinder").getDouble("radius");
                }
                catch (JSONException e) {
                    r = 1.0;
                }
                obj = new PolyCylinder(h, r);
            }
            catch (JSONException eCylinder) {
                try {
                    double r;
                    aShape.getJSONObject("Sphere");
                    try {
                        r = aShape.getJSONObject("Sphere").getDouble("radius");
                    }
                    catch (JSONException e) {
                        r = 1.0;
                    }
                    obj = new PolySphere(r);
                }
                catch (JSONException eSphere) {
                    try {
                        double z;
                        double y;
                        double x;
                        aShape.getJSONObject("Box");
                        try {
                            String[] xyz = aShape.getJSONObject("Box").getString("size").split("[ \t\n]");
                            x = Double.parseDouble(xyz[0]);
                            y = Double.parseDouble(xyz[1]);
                            z = Double.parseDouble(xyz[2]);
                        }
                        catch (Exception e) {
                            z = 1.0;
                            y = 1.0;
                            x = 1.0;
                        }
                        obj = new Box(x, y, z);
                    }
                    catch (JSONException eFaceSet) {
                        try {
                            JSONObject indexedFaceSet = aShape.getJSONObject("IndexedFaceSet");
                            String indexstr = indexedFaceSet.getString("coordIndex").trim().replaceAll(",", "");
                            String[] indexes = indexstr.split("[ \t\n]");
                            String pointstr = indexedFaceSet.getJSONObject("Coordinate").getString("point").trim().replaceAll(",", "");
                            String[] xyzPoints = pointstr.split("[ \t\n]");
                            int nPoints = xyzPoints.length / 3;
                            Vector3D[] vertex = new Vector3D[nPoints];
                            int i = 0;
                            while (i < nPoints) {
                                vertex[i] = new Vector3D(Double.parseDouble(xyzPoints[i * 3]), Double.parseDouble(xyzPoints[i * 3 + 1]), Double.parseDouble(xyzPoints[i * 3 + 2]));
                                ++i;
                            }
                            int j = 0;
                            i = 0;
                            while (i != -1) {
                                i = indexstr.indexOf("-1", i + 1);
                                ++j;
                            }
                            int nFaces = j - 1;
                            int nEdges = indexes.length - nFaces;
                            int[][] edges = new int[nEdges][2];
                            Object3D.PolygonEdgeIndexes[] faces = new Object3D.PolygonEdgeIndexes[nFaces];
                            obj = new Object3D();
                            int m = 0;
                            int l = 0;
                            int k = 0;
                            j = 0;
                            i = 0;
                            while (i < indexes.length) {
                                if (Integer.parseInt(indexes[i]) == -1) {
                                    faces[m] = obj.new Object3D.PolygonEdgeIndexes(obj, i - j);
                                    k = j;
                                    while (k < i) {
                                        faces[m].edge[k - j] = l;
                                        edges[l][0] = Integer.parseInt(indexes[k]);
                                        edges[l][1] = Integer.parseInt(indexes[k + 1]);
                                        ++l;
                                        ++k;
                                    }
                                    ++m;
                                    edges[l - 1][1] = Integer.parseInt(indexes[j]);
                                    j = i + 1;
                                }
                                ++i;
                            }
                            obj.setMesh(new Mesh(vertex.length, edges.length, vertex, edges));
                            obj.setFacet(faces, nFaces);
                        }
                        catch (JSONException e) {
                            System.err.println("Unknown shape: " + aShape.toString());
                            obj = new Object3D();
                        }
                    }
                }
            }
        }
        return obj;
    }

    static Color getColor(JSONObject aShape) {
        Color color = null;
        try {
            JSONObject appear = aShape.getJSONObject("Appearance");
            JSONx3dFactory.defKey(appear);
            appear = JSONx3dFactory.useKey(appear);
            String[] rgb = appear.getJSONObject("Material").getString("diffuseColor").split("[ \t\n]");
            color = new Color(Float.parseFloat(rgb[0]), Float.parseFloat(rgb[1]), Float.parseFloat(rgb[2]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    static Matrix3D getTranslation(JSONObject aTransform) {
        return JSONx3dFactory.getTranslationMatrix(aTransform, "translation");
    }

    static Matrix3D getPosition(JSONObject aTransform) {
        Matrix3D m3d = null;
        try {
            aTransform.getJSONObject("position");
            m3d = JSONx3dFactory.getTranslationMatrix(aTransform, "position");
        }
        catch (JSONException e) {
            m3d = Matrix3D.translation(0.0, 0.0, -10.0);
        }
        return Matrix3D.MatrixAsMatrix3D(m3d.inv());
    }

    static Matrix3D getTranslationMatrix(JSONObject aTransform, String str) {
        Matrix3D m3d = null;
        try {
            String[] xyz = aTransform.getString(str).split("[ \t\n]");
            m3d = Matrix3D.translation(Double.parseDouble(xyz[0]), Double.parseDouble(xyz[1]), -Double.parseDouble(xyz[2]));
        }
        catch (JSONException e) {
            m3d = new Matrix3D();
        }
        return m3d;
    }

    static Matrix3D getRotation(JSONObject aTransform) {
        return JSONx3dFactory.getRotationMatrix(aTransform, "rotation");
    }

    static Matrix3D getOrientation(JSONObject aTransform) {
        return Matrix3D.MatrixAsMatrix3D(JSONx3dFactory.getRotationMatrix(aTransform, "orientation").inv());
    }

    static Matrix3D getRotationMatrix(JSONObject aTransform, String str) {
        Matrix3D m3d = new Matrix3D();
        try {
            String[] xyza = aTransform.getString(str).split("[ \t\n]+");
            double fx = Double.parseDouble(xyza[0]);
            double fy = Double.parseDouble(xyza[1]);
            double fz = Double.parseDouble(xyza[2]);
            double teta = Double.parseDouble(xyza[3]);
            if (fx != 0.0) {
                m3d = Matrix3D.MatrixAsMatrix3D(m3d.mul(Matrix3D.rotationX(teta * fx)));
            }
            if (fy != 0.0) {
                m3d = Matrix3D.MatrixAsMatrix3D(m3d.mul(Matrix3D.rotationY(teta * fy)));
            }
            if (fz != 0.0) {
                m3d = Matrix3D.MatrixAsMatrix3D(m3d.mul(Matrix3D.rotationZ(teta * fz)));
            }
        }
        catch (JSONException e) {
            m3d = new Matrix3D();
        }
        return m3d;
    }

    static Matrix3D getScale(JSONObject aTransform) {
        return JSONx3dFactory.getScaleMatrix(aTransform, "scale");
    }

    static Matrix3D getScaleMatrix(JSONObject aTransform, String str) {
        Matrix3D m3d = null;
        try {
            String[] xyz = aTransform.getString(str).split("[ \t\n]");
            m3d = Matrix3D.scale(Double.parseDouble(xyz[0]), Double.parseDouble(xyz[1]), -Double.parseDouble(xyz[2]));
        }
        catch (JSONException e) {
            m3d = new Matrix3D();
        }
        return m3d;
    }

    public static Object3D getScene(JSONObject toplevel) {
        JSONObject jScene = null;
        try {
            jScene = toplevel.getJSONObject("X3D").getJSONObject("Scene").getJSONObject("ProtoDeclare").getJSONObject("ProtoBody");
        }
        catch (Exception e) {
            try {
                jScene = toplevel.getJSONObject("X3D").getJSONObject("Scene");
            }
            catch (Exception e1) {
                return new Object3D();
            }
        }
        Object3D scene = JSONx3dFactory.getObject3D(jScene);
        scene.setPosition(JSONx3dFactory.getPosition(jScene));
        scene.setOrientation(JSONx3dFactory.getOrientation(jScene));
        scene.reset();
        return scene;
    }
}

