/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.math.Matrix;
import org.yriarte.math.Vector;
import org.yriarte.mini3D.Matrix3D;

public class Vector3D
extends Vector {
    public static Vector3D MatrixAsVector3D(Matrix aMatrix) {
        return new Vector3D(aMatrix.getCell());
    }

    public Vector3D() {
        this.nLines = 4;
        this.nCols = 1;
        this.cell = new double[this.nLines][this.nCols];
        this.cell[0][0] = 0.0;
        this.cell[1][0] = 0.0;
        this.cell[2][0] = 0.0;
        this.cell[3][0] = 1.0;
    }

    public Vector3D(double x, double y, double z) {
        this.nLines = 4;
        this.nCols = 1;
        this.cell = new double[this.nLines][this.nCols];
        this.cell[0][0] = x;
        this.cell[1][0] = y;
        this.cell[2][0] = z;
        this.cell[3][0] = 1.0;
    }

    public Vector3D(double[][] cell) {
        this.nLines = 4;
        this.nCols = 1;
        this.cell = cell;
    }

    public Vector3D(Matrix aMatrix) {
        this.nLines = 4;
        this.nCols = 1;
        this.cell = new double[this.nLines][this.nCols];
        this.cell[0][0] = aMatrix.getCell()[0][0];
        this.cell[1][0] = aMatrix.getCell()[1][0];
        this.cell[2][0] = aMatrix.getCell()[2][0];
        this.cell[3][0] = 1.0;
    }

    public Vector3D(Matrix aMatrix, int column) {
        this.nLines = 4;
        this.nCols = 1;
        this.cell = new double[this.nLines][this.nCols];
        this.cell[0][0] = aMatrix.getCell()[0][column];
        this.cell[1][0] = aMatrix.getCell()[1][column];
        this.cell[2][0] = aMatrix.getCell()[2][column];
        this.cell[3][0] = 1.0;
    }

    public Matrix3D positionMatrix() {
        return Matrix3D.translation(this.cell[0][0], this.cell[1][0], this.cell[2][0]);
    }

    public Vector3D transformThis(Matrix aMatrix) {
        double[][] mCell = aMatrix.getCell();
        double x = mCell[0][0] * this.cell[0][0] + mCell[0][1] * this.cell[1][0] + mCell[0][2] * this.cell[2][0] + mCell[0][3];
        double y = mCell[1][0] * this.cell[0][0] + mCell[1][1] * this.cell[1][0] + mCell[1][2] * this.cell[2][0] + mCell[1][3];
        double z = mCell[2][0] * this.cell[0][0] + mCell[2][1] * this.cell[1][0] + mCell[2][2] * this.cell[2][0] + mCell[2][3];
        this.cell[0][0] = x;
        this.cell[1][0] = y;
        this.cell[2][0] = z;
        return this;
    }

    public double getX() {
        return this.cell[0][0];
    }

    public double getY() {
        return this.cell[1][0];
    }

    public double getZ() {
        return this.cell[2][0];
    }

    public Vector3D setX(double aDouble) {
        this.cell[0][0] = aDouble;
        return this;
    }

    public Vector3D setY(double aDouble) {
        this.cell[1][0] = aDouble;
        return this;
    }

    public Vector3D setZ(double aDouble) {
        this.cell[2][0] = aDouble;
        return this;
    }
}

