/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Object3D;
import org.yriarte.mini3D.Vector3D;

public class PolySphere
extends Object3D {
    private void init(int nTotal, int n, double r, double frad, boolean full) {
        if (n < 3) {
            n = 3;
        }
        if (nTotal < n) {
            nTotal = n;
        }
        this.nFacet = n * (n - 1);
        this.facet = new Object3D.PolygonEdgeIndexes[this.nFacet];
        double step = Math.PI * 2 / (double)nTotal;
        int nV = n * (n - 2) + 2;
        Vector3D[] v = new Vector3D[nV];
        int nE = 2 * (nV - 2) + n;
        int[][] e = new int[nE][2];
        int f = 0;
        v[nV - 1] = new Vector3D(0.0, r, 0.0);
        v[nV - 2] = new Vector3D(0.0, -r, 0.0);
        int i = 0;
        while (i < n) {
            e[nE - (i + 1)][0] = nV - 1;
            e[nE - (i + 1)][1] = i;
            this.facet[f] = new Object3D.PolygonEdgeIndexes(this, 3);
            this.facet[f].edge[0] = nE - (i + 1);
            this.facet[f].edge[1] = i;
            this.facet[f].edge[2] = (i + 1) % n;
            ++f;
            ++i;
        }
        i = 0;
        while (i < n - 2) {
            double rLat = frad * r * Math.sin(Math.PI * (double)(i + 1) / (double)(n - 1));
            double y = r * Math.cos(Math.PI * (double)(i + 1) / (double)(n - 1));
            int j = 0;
            while (j < n) {
                int iV = i * n + j;
                v[iV] = new Vector3D(rLat * Math.cos((double)j * step), y, rLat * Math.sin((double)j * step));
                e[iV][0] = iV;
                e[iV][1] = i * n + (j + 1) % n;
                e[n * (n - 2) + iV][1] = iV;
                if (i < n - 3) {
                    e[n * (n - 2) + iV][0] = iV + n;
                    if (full) {
                        this.facet[f] = new Object3D.PolygonEdgeIndexes(this, 4);
                        this.facet[f].edge[2] = (i + 1) * n + (j + 1) % n;
                        this.facet[f].edge[3] = (i + 1) * n + j;
                    } else {
                        this.facet[f] = new Object3D.PolygonEdgeIndexes(this, 3);
                        this.facet[f].edge[2] = (i + 1) * n + (j + 1) % n;
                    }
                } else {
                    e[n * (n - 2) + iV][0] = nV - 2;
                    this.facet[f] = new Object3D.PolygonEdgeIndexes(this, 3);
                    this.facet[f].edge[2] = n * (n - 2) + iV;
                }
                this.facet[f].edge[0] = iV;
                this.facet[f].edge[1] = i * n + (j + 1) % n;
                ++f;
                ++j;
            }
            ++i;
        }
        this.mesh = new Mesh(nV, nE, v, e);
    }

    public PolySphere(int nTotal, int n, double r, double frad, boolean full) {
        this.init(nTotal, n, r, frad, full);
    }

    public PolySphere(int nTotal, int n, double r, double frad) {
        this.init(nTotal, n, r, frad, true);
    }

    public PolySphere(int n, double r, double frad) {
        this.init(n, n, r, frad, true);
    }

    public PolySphere(int n, double r) {
        this.init(n, n, r, 1.0, true);
    }

    public PolySphere(double r, double frad) {
        this.init(Object3D.N_DEFAULT, Object3D.N_DEFAULT, r, frad, true);
    }

    public PolySphere(double r) {
        this.init(Object3D.N_DEFAULT, Object3D.N_DEFAULT, r, 1.0, true);
    }
}

