/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Object3D;
import org.yriarte.mini3D.Vector3D;

public class PolyCylinder
extends Object3D {
    private void init(int nTotal, int n, double h, double r) {
        if (n < 3) {
            n = 3;
        }
        this.nFacet = n + 2;
        this.facet = new Object3D.PolygonEdgeIndexes[this.nFacet];
        this.facet[n] = new Object3D.PolygonEdgeIndexes(this, this, n);
        this.facet[n + 1] = new Object3D.PolygonEdgeIndexes(this, this, n);
        double dh = h / 2.0;
        double step = Math.PI * 2 / (double)nTotal;
        Vector3D[] v = new Vector3D[n * 2];
        int[][] e = new int[n * 3][2];
        int i = 0;
        while (i < n) {
            v[i] = new Vector3D(r * Math.cos((double)i * step), -dh, r * Math.sin((double)i * step));
            e[i][0] = i;
            e[i][1] = (i + 1) % n;
            this.facet[n].edge[i] = i;
            v[i + n] = new Vector3D(r * Math.cos((double)i * step), dh, r * Math.sin((double)i * step));
            e[i + n][0] = i + n;
            e[i + n][1] = (i + 1) % n + n;
            this.facet[n + 1].edge[i] = i + n;
            e[i + n * 2][0] = i;
            e[i + n * 2][1] = i + n;
            this.facet[i] = new Object3D.PolygonEdgeIndexes(this, this, 4);
            this.facet[i].edge[0] = i;
            this.facet[i].edge[1] = (i + 1) % n;
            this.facet[i].edge[2] = (i + 1) % n + n;
            this.facet[i].edge[3] = i + n;
            ++i;
        }
        this.mesh = new Mesh(n * 2, n * 3, v, e);
    }

    public PolyCylinder(int nTotal, int n, double h, double r) {
        this.init(nTotal, n, h, r);
    }

    public PolyCylinder(int n, double h, double r) {
        this.init(n, n, h, r);
    }

    public PolyCylinder(double h, double r) {
        this.init(Object3D.N_DEFAULT, Object3D.N_DEFAULT, h, r);
    }
}

