/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Object3D;
import org.yriarte.mini3D.Vector3D;

public class PolyCone
extends Object3D {
    private void init(int nTotal, int n, double h, double r) {
        if (n < 3) {
            n = 3;
        }
        if (nTotal < n) {
            nTotal = n;
        }
        this.nFacet = n + 1;
        this.facet = new Object3D.PolygonEdgeIndexes[this.nFacet];
        this.facet[n] = new Object3D.PolygonEdgeIndexes(this, n);
        double dh = h / 2.0;
        double step = Math.PI * 2 / (double)nTotal;
        Vector3D[] v = new Vector3D[n + 1];
        int[][] e = new int[n * 2][2];
        int i = 0;
        while (i < n) {
            v[i] = new Vector3D(r * Math.cos((double)i * step), -dh, r * Math.sin((double)i * step));
            e[i][0] = i;
            e[i][1] = (i + 1) % n;
            this.facet[n].edge[i] = i;
            e[i + n][0] = n;
            e[i + n][1] = i;
            this.facet[i] = new Object3D.PolygonEdgeIndexes(this, 3);
            this.facet[i].edge[0] = i;
            this.facet[i].edge[1] = (i + 1) % n;
            this.facet[i].edge[2] = i + n;
            ++i;
        }
        v[n] = new Vector3D(0.0, dh, 0.0);
        this.mesh = new Mesh(n + 1, n * 2, v, e);
    }

    public PolyCone(int n0, int n, double h, double r) {
        this.init(n0, n, h, r);
    }

    public PolyCone(int n, double h, double r) {
        this.init(n, n, h, r);
    }

    public PolyCone(double h, double r) {
        this.init(Object3D.N_DEFAULT, Object3D.N_DEFAULT, h, r);
    }
}

