/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import org.yriarte.math.Matrix;
import org.yriarte.mini3D.Matrix3D;
import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Vector3D;

public class Object3D {
    public static final int DRAW_WIREFRAME = 0;
    public static final int DRAW_FACETS = 1;
    public static final int BRIGHT_SCALE = 255;
    public static final int BRIGHT_SCENE = 0;
    public static final int BRIGHT_OBJECT = 1;
    public static int BRIGHT_MODE = 1;
    public static int DRAW_DEFAULT = 1;
    public static int N_DEFAULT = 12;
    public static Color COLOR_DEFAULT = Color.GRAY;
    protected Color color = null;
    protected int drawMode = DRAW_DEFAULT;
    protected float brightIncrement = 0.0f;
    protected float brightIncLocal = 0.0f;
    protected int brightDelta = 0;
    protected Matrix position;
    protected Matrix orientation;
    protected Matrix transformation;
    protected Matrix updatedTransform = null;
    protected Mesh mesh = new Mesh();
    protected int nChild = 0;
    protected int nFacet = 0;
    protected int nFacetTotal = 0;
    protected Object3D[] child = null;
    protected Object3D parent = null;
    protected PolygonEdgeIndexes[] facet = null;
    protected PolygonEdgeIndexes[] facetTotal = null;
    protected int selectedVertex = -1;
    protected Object3D selectedObject = null;

    public Object3D() {
        this.position = new Matrix3D();
        this.orientation = new Matrix3D();
        this.transformation = new Matrix3D();
    }

    public Object3D reset() {
        return this.reset(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Object3D reset(double trnX, double trnY, double trnZ, double trn0X, double trn0Y, double trn0Z, double rotX, double rotY, double rotZ, double rot0X, double rot0Y, double rot0Z) {
        this.selectedVertex = -1;
        this.selectedObject = null;
        if (rot0X != 0.0) {
            this.mesh.transformThis(Matrix3D.rotationX(rot0X));
        }
        if (rot0Y != 0.0) {
            this.mesh.transformThis(Matrix3D.rotationY(rot0Y));
        }
        if (rot0Z != 0.0) {
            this.mesh.transformThis(Matrix3D.rotationZ(rot0Z));
        }
        if (trn0X != 0.0 || trn0Y != 0.0 || trn0Z != 0.0) {
            this.mesh.transformThis(Matrix3D.translation(trn0X, trn0Y, trn0Z));
        }
        if (rotX != 0.0) {
            this.orientation = this.orientation.mul(Matrix3D.rotationX(rotX));
        }
        if (rotY != 0.0) {
            this.orientation = this.orientation.mul(Matrix3D.rotationY(rotY));
        }
        if (rotZ != 0.0) {
            this.orientation = this.orientation.mul(Matrix3D.rotationZ(rotZ));
        }
        if (trnX != 0.0 || trnY != 0.0 || trnZ != 0.0) {
            this.position = this.position.mul(Matrix3D.translation(trnX, trnY, trnZ));
        }
        this.transformation = this.position.mul(this.orientation);
        this.updatedTransform = null;
        if (this.color == null) {
            this.color = this.parent != null ? this.parent.color : COLOR_DEFAULT;
        }
        this.brightIncLocal = this.nFacet != 0 ? 255 / this.nFacet : 0;
        this.nFacetTotal = this.nFacet;
        int i = 0;
        while (i < this.nChild) {
            this.child[i].reset();
            this.nFacetTotal += this.child[i].nFacetTotal;
            ++i;
        }
        this.brightIncrement = this.nFacetTotal != 0 ? 255 / this.nFacetTotal : 0;
        if (this.parent == null && this.nFacetTotal > 0) {
            this.facetTotal = new PolygonEdgeIndexes[this.nFacetTotal];
            this.buildFacetList(this.facetTotal, 0);
        }
        if (this.nFacetTotal == 0 && this.mesh != null) {
            this.drawMode = 0;
        }
        return this;
    }

    public Object3D resetScale(double scaleX, double scaleY, double scaleZ) {
        if (scaleX != 1.0 || scaleY != 1.0 || scaleZ != 1.0) {
            this.mesh.transformThis(Matrix3D.scale(scaleX, scaleY, scaleZ));
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Matrix getOrientation() {
        return this.orientation;
    }

    public Object3D setOrientation(Matrix orientation) {
        this.orientation = orientation;
        this.transformation = this.position.mul(orientation);
        this.updatedTransform = null;
        return this;
    }

    public Matrix getPosition() {
        return this.position;
    }

    public Object3D setPosition(Matrix position) {
        this.position = position;
        this.transformation = position.mul(this.orientation);
        this.updatedTransform = null;
        return this;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public Object3D setMesh(Mesh mesh) {
        this.mesh = mesh;
        return this;
    }

    public PolygonEdgeIndexes[] getFacet() {
        return this.facet;
    }

    public void setFacet(PolygonEdgeIndexes[] facet, int nFacet) {
        this.facet = facet;
        this.nFacet = nFacet;
    }

    public int getNFacet() {
        return this.nFacet;
    }

    public Object3D transform(Matrix trans) {
        this.transformation = this.transformation.mul(trans);
        this.updatedTransform = null;
        return this;
    }

    public Object3D transformMesh(Matrix trans) {
        this.mesh.transformThis(trans);
        return this;
    }

    public Object3D transformMeshes(Matrix trans) {
        this.transformMesh(trans);
        int i = 0;
        while (i < this.nChild) {
            this.child[i].transformMeshes(trans);
            ++i;
        }
        return this;
    }

    public Object3D addChild(Object3D obj) {
        Object3D[] prevChild = this.child;
        this.child = new Object3D[this.nChild + 1];
        int i = 0;
        while (i < this.nChild) {
            this.child[i] = prevChild[i];
            ++i;
        }
        this.child[this.nChild] = obj;
        obj.parent = this;
        if (obj.color == null) {
            obj.color = this.color;
        }
        ++this.nChild;
        return this;
    }

    public Object3D getChild(int i) {
        if (this.child == null) {
            return null;
        }
        return this.child[i];
    }

    private int buildFacetList(PolygonEdgeIndexes[] facetList, int startIndex) {
        int i = 0;
        while (i < this.nFacet) {
            facetList[startIndex++] = this.facet[i];
            ++i;
        }
        i = 0;
        while (i < this.nChild) {
            startIndex = this.child[i].buildFacetList(facetList, startIndex);
            ++i;
        }
        return startIndex;
    }

    private void sortFacetTotal() {
        PolygonEdgeIndexes tmpFacet;
        int n = this.nFacetTotal;
        do {
            tmpFacet = null;
            int i = 1;
            while (i < n) {
                if (this.facetTotal[i - 1].z < this.facetTotal[i].z) {
                    tmpFacet = this.facetTotal[i];
                    this.facetTotal[i] = this.facetTotal[i - 1];
                    this.facetTotal[i - 1] = tmpFacet;
                }
                ++i;
            }
            --n;
        } while (tmpFacet != null);
    }

    private int updateWireframe(int focal, int screenX, int screenY) {
        int nEdge = 0;
        this.updatedTransform = this.parent != null && this.parent.updatedTransform != null ? this.parent.updatedTransform.mul(this.transformation) : this.transformation;
        int i = 0;
        while (i < this.nChild) {
            nEdge += this.child[i].updateWireframe(focal, screenX, screenY);
            ++i;
        }
        if (this.mesh.getNEdge() > 0) {
            this.mesh.setWireframe(this.mesh.transform(this.updatedTransform).updateWireframe(focal, screenX, screenY));
        }
        return nEdge + this.mesh.getNEdge();
    }

    private void updateFacets(int focal, int screenX, int screenY) {
        int i = 0;
        while (i < this.nChild) {
            this.child[i].updateFacets(focal, screenX, screenY);
            ++i;
        }
        i = 0;
        while (i < this.nFacet) {
            this.facet[i].updatePolygon();
            ++i;
        }
    }

    public void update(int focal, int screenX, int screenY) {
        this.updateWireframe(focal, screenX, screenY);
        if (this.drawMode == 1) {
            this.updateFacets(focal, screenX, screenY);
            if (this.facetTotal != null) {
                this.sortFacetTotal();
            }
        }
    }

    private Color colorDelta(Color baseColor, int brightDelta) {
        int rgb = baseColor.getRGB();
        int r = Math.max(Math.min(((rgb & 0xFF0000) >> 16) + brightDelta, 255), 0);
        int g = Math.max(Math.min(((rgb & 0xFF00) >> 8) + brightDelta, 255), 0);
        int b = Math.max(Math.min((rgb & 0xFF) + brightDelta, 255), 0);
        return new Color(r, g, b);
    }

    public void paint(Graphics graphics) {
        block7: {
            int i;
            block8: {
                this.brightDelta = -127;
                i = 0;
                while (i < this.nChild) {
                    this.child[i].paint(graphics);
                    ++i;
                }
                if (this.drawMode != 1 || this.facetTotal == null) break block8;
                i = 0;
                while (i < this.nFacetTotal) {
                    if (BRIGHT_MODE == 0) {
                        graphics.setColor(this.colorDelta(((PolygonEdgeIndexes)this.facetTotal[i]).obj.color, this.brightDelta));
                        this.brightDelta = (int)((float)this.brightDelta + this.brightIncrement);
                    } else {
                        graphics.setColor(this.colorDelta(((PolygonEdgeIndexes)this.facetTotal[i]).obj.color, ((PolygonEdgeIndexes)this.facetTotal[i]).obj.brightDelta));
                        ((PolygonEdgeIndexes)this.facetTotal[i]).obj.brightDelta = (int)((float)((PolygonEdgeIndexes)this.facetTotal[i]).obj.brightDelta + ((PolygonEdgeIndexes)this.facetTotal[i]).obj.brightIncLocal);
                    }
                    if (this.facetTotal[i].z >= 0) {
                        this.facetTotal[i].paint(graphics);
                        ++i;
                        continue;
                    }
                    break block7;
                }
                break block7;
            }
            if (this.drawMode != 0) break block7;
            graphics.setColor(this.color);
            int nEdge = this.mesh.getNEdge();
            int[][] lines = this.mesh.getLines();
            i = 0;
            while (i < nEdge) {
                if (lines[i][4] >= 0) {
                    graphics.drawLine(lines[i][0], lines[i][1], lines[i][2], lines[i][3]);
                }
                ++i;
            }
        }
    }

    public void setDrawMode(int d) {
        this.drawMode = d;
        if (this.nFacetTotal == 0 && this.mesh != null) {
            this.drawMode = 0;
        }
        int i = 0;
        while (i < this.nChild) {
            this.child[i].setDrawMode(d);
            ++i;
        }
    }

    public int selectVertex(int x, int y, int r) {
        this.selectedVertex = -1;
        this.selectedObject = null;
        if (this.mesh != null) {
            this.selectedVertex = this.mesh.selectVertex(x, y, r);
            if (this.selectedVertex != -1) {
                this.selectedObject = this;
                return this.selectedVertex;
            }
        }
        int i = 0;
        while (i < this.nChild) {
            this.selectedVertex = this.child[i].selectVertex(x, y, r);
            if (this.selectedVertex != -1) {
                this.selectedObject = this.child[i].selectedObject;
                return this.selectedVertex;
            }
            ++i;
        }
        return this.selectedVertex;
    }

    public Vector3D getSelectedVertex() {
        if (this.selectedVertex != -1) {
            return this.selectedObject.getMesh().getVertex()[this.selectedVertex];
        }
        return null;
    }

    public Matrix calculateBounds() {
        Matrix mxXyYzZ = this.mesh.calculateBounds();
        int i = 0;
        while (i < this.nChild) {
            Matrix mChildBounds = this.child[i].calculateBounds();
            int j = 0;
            while (j < 3) {
                mxXyYzZ.getCell()[j][0] = Math.min(mxXyYzZ.getCell()[j][0], mChildBounds.getCell()[j][0]);
                mxXyYzZ.getCell()[j][1] = Math.max(mxXyYzZ.getCell()[j][1], mChildBounds.getCell()[j][1]);
                ++j;
            }
            ++i;
        }
        return mxXyYzZ;
    }

    public class PolygonEdgeIndexes {
        private Object3D obj;
        private int z = 0;
        private int nEdge = 0;
        public int[] edge = null;
        private Polygon polygon;

        public PolygonEdgeIndexes(Object3D o, int n) {
            this.obj = o;
            this.nEdge = n;
            this.edge = new int[n];
            this.z = 0;
        }

        public void updatePolygon() {
            int[] xP = new int[this.nEdge];
            int[] yP = new int[this.nEdge];
            this.z = 0;
            int[][] lines = this.obj.mesh.getLines();
            int i = 0;
            while (i < this.nEdge) {
                xP[i] = lines[this.edge[i]][0];
                yP[i] = lines[this.edge[i]][1];
                this.z += lines[this.edge[i]][4];
                ++i;
            }
            this.polygon = new Polygon(xP, yP, this.nEdge);
            this.z /= this.nEdge;
        }

        public void updatePolygon(int[] xP, int[] yP) {
            this.polygon = new Polygon(xP, yP, this.nEdge);
        }

        public void paint(Graphics g) {
            g.fillPolygon(this.polygon);
        }
    }
}

