/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import org.yriarte.math.Matrix;
import org.yriarte.mini3D.Buffered3DGraphics;
import org.yriarte.mini3D.Matrix3D;
import org.yriarte.mini3D.Object3D;

public class Mini3DPanel
extends Panel
implements ActionListener,
Observer,
ItemListener {
    private static final int NAV_ROTATION = 0;
    private static final int NAV_TRANSLATION = 1;
    private static final int NAV_ZOOM = 2;
    private static final int NAV_FOCAL = 3;
    public static final int DEFAULT_FOCAL = 100;
    private Button toggleControls = new Button("...");
    private Checkbox drawFacets = null;
    private Choice navMenu = null;
    private TextField focalField = null;
    private TextField zoomField = null;
    private Label focalLabel = null;
    private Label zoomLabel = null;
    private Object3D model = null;
    private Buffered3DGraphics graphics3D = null;
    private int width;
    private int height;
    private int dragX;
    private int dragY;
    private double zoom = 0.0;
    private boolean controlsVisible = true;

    public Mini3DPanel() {
        this.toggleControls.addActionListener(this);
        this.drawFacets = new Checkbox("Facets", true);
        this.drawFacets.addItemListener(this);
        this.navMenu = new Choice();
        this.navMenu.addItemListener(this);
        this.navMenu.addItem("Rotate");
        this.navMenu.addItem("Translate");
        this.navMenu.addItem("Zoom");
        this.navMenu.addItem("Focal");
        this.focalLabel = new Label(" Focal:");
        this.focalField = new TextField(4);
        this.focalField.addActionListener(this);
        this.zoomLabel = new Label(" Zoom:");
        this.zoomField = new TextField(4);
        this.zoomField.addActionListener(this);
    }

    public void showControls(boolean show) {
        this.navMenu.setVisible(show);
        this.drawFacets.setVisible(show);
        this.focalLabel.setVisible(show);
        this.focalField.setVisible(show);
        this.zoomLabel.setVisible(show);
        this.zoomField.setVisible(show);
    }

    public Object3D getModel() {
        return this.model;
    }

    public void init(Object3D scene, int focal, double zoomFactor) {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.model = scene;
        this.zoom = zoomFactor;
        if (this.zoom == 0.0) {
            Matrix bounds = this.model.calculateBounds();
            this.zoom = (bounds.getCell()[2][1] - bounds.getCell()[2][0]) / (double)(this.height * 2);
        }
        this.add(this.toggleControls);
        this.add(this.navMenu);
        this.add(this.drawFacets);
        this.add(this.focalLabel);
        this.add(this.focalField);
        this.add(this.zoomLabel);
        this.add(this.zoomField);
        Image img = this.createImage(this.width, this.height);
        this.graphics3D = new Buffered3DGraphics(this.model, img, this.width, this.height, focal);
        this.graphics3D.setDrawMode(this.drawFacets.getState() ? 1 : 0);
        this.model.reset();
        this.graphics3D.updateModel();
        this.repaint();
    }

    public void init(Object3D scene) {
        this.init(scene, 100, 0.0);
    }

    public void paint(Graphics g) {
        if (this.graphics3D != null) {
            this.graphics3D.updateView(g);
        }
    }

    public void update(Graphics g) {
        this.focalField.setText(Integer.toString(this.graphics3D.getFocal()));
        this.zoomField.setText(Double.toString(this.zoom));
        this.showControls(this.controlsVisible);
        this.paint(g);
    }

    public boolean mouseDown(Event arg0, int arg1, int arg2) {
        this.dragX = arg1;
        this.dragY = arg2;
        return true;
    }

    public boolean mouseDrag(Event arg0, int arg1, int arg2) {
        int navcmd = this.navMenu.getSelectedIndex();
        switch (navcmd) {
            case 0: {
                double deltaX = (double)((arg1 - this.dragX) * 2) * Math.PI / (double)this.width;
                double deltaY = (double)((this.dragY - arg2) * 2) * Math.PI / (double)this.height;
                this.model.setOrientation(this.model.getOrientation().mul(Matrix3D.rotationY(deltaX).mul(Matrix3D.rotationX(deltaY))));
                break;
            }
            case 1: {
                double deltaX = this.zoom * (double)(arg1 - this.dragX);
                double deltaY = this.zoom * (double)(this.dragY - arg2);
                this.model.setPosition(this.model.getPosition().mul(Matrix3D.translation(deltaX, deltaY, 0.0)));
                break;
            }
            case 3: {
                this.graphics3D.setFocal(this.graphics3D.getFocal() + 100 * (arg2 - this.dragY) / this.height);
                break;
            }
            case 2: {
                double deltaZ = this.zoom * (double)(arg2 - this.dragY);
                this.model.setPosition(this.model.getPosition().mul(Matrix3D.translation(0.0, 0.0, deltaZ)));
            }
        }
        this.graphics3D.updateModel();
        this.repaint();
        this.dragX = arg1;
        this.dragY = arg2;
        return true;
    }

    public boolean mouseUp(Event arg0, int arg1, int arg2) {
        this.dragY = 0;
        this.dragX = 0;
        return true;
    }

    public void itemStateChanged(ItemEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.drawFacets) {
            this.graphics3D.setDrawMode(this.drawFacets.getState() ? 1 : 0);
            this.graphics3D.updateModel();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.toggleControls) {
            this.controlsVisible = !this.controlsVisible;
            this.repaint();
        } else if (src == this.focalField) {
            this.graphics3D.setFocal(Integer.valueOf(this.focalField.getText()));
            this.graphics3D.updateModel();
            this.repaint();
        } else if (src == this.zoomField) {
            this.zoom = Double.valueOf(this.zoomField.getText());
        }
    }

    public void update(Observable arg0, Object arg1) {
        this.repaint();
    }
}

