/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.math.Matrix;
import org.yriarte.mini3D.Vector3D;

public class Mesh {
    protected int nVertex;
    protected int nEdge;
    protected Vector3D[] vertex;
    protected int[][] edge;
    protected int focal;
    protected int screenX;
    protected int screenY;
    protected int[] scrX;
    protected int[] scrY;
    protected int[][] lines;

    public Mesh() {
        this.nEdge = 0;
        this.nVertex = 0;
        this.vertex = null;
        this.edge = null;
        this.lines = null;
        this.scrY = null;
        this.scrX = null;
    }

    public Mesh(int nV, int nE, Vector3D[] v, int[][] e) {
        this.nVertex = nV;
        this.nEdge = nE;
        this.vertex = v;
        this.edge = e;
        this.scrX = new int[this.nVertex];
        this.scrY = new int[this.nVertex];
        this.lines = new int[this.nEdge][5];
    }

    public Mesh(Mesh aMesh) {
        this(aMesh.nVertex, aMesh.nEdge, aMesh.vertex, aMesh.edge);
    }

    public int getNVertex() {
        return this.nVertex;
    }

    public int getNEdge() {
        return this.nEdge;
    }

    public Vector3D[] getVertex() {
        return this.vertex;
    }

    public int[][] getLines() {
        return this.lines;
    }

    public Mesh transform(Matrix trans) {
        if (this.nVertex == 0) {
            return this;
        }
        Vector3D[] transVertex = new Vector3D[this.nVertex];
        int i = 0;
        while (i < this.nVertex) {
            transVertex[i] = Vector3D.MatrixAsVector3D(trans.mul(this.vertex[i]));
            ++i;
        }
        return new Mesh(this.nVertex, this.nEdge, transVertex, this.edge);
    }

    public Mesh transformThis(Matrix trans) {
        if (this.nVertex == 0) {
            return this;
        }
        int i = 0;
        while (i < this.nVertex) {
            this.vertex[i].transformThis(trans);
            ++i;
        }
        return this;
    }

    public Mesh updateWireframe(int foc, int sX, int sY) {
        if (this.nEdge == 0) {
            return null;
        }
        this.focal = foc;
        this.screenX = sX;
        this.screenY = sY;
        int x0 = this.screenX / 2;
        int y0 = this.screenY / 2;
        int i = 0;
        while (i < this.nVertex) {
            double z = this.vertex[i].getCell()[2][0] > 0.0 ? this.vertex[i].getCell()[2][0] : 0.001;
            this.scrX[i] = (int)((double)x0 + this.vertex[i].getCell()[0][0] * (double)this.focal / z);
            this.scrY[i] = (int)((double)y0 - this.vertex[i].getCell()[1][0] * (double)this.focal / z);
            ++i;
        }
        i = 0;
        while (i < this.nEdge) {
            this.lines[i][0] = this.scrX[this.edge[i][0]];
            this.lines[i][1] = this.scrY[this.edge[i][0]];
            this.lines[i][2] = this.scrX[this.edge[i][1]];
            this.lines[i][3] = this.scrY[this.edge[i][1]];
            this.lines[i][4] = (int)(this.vertex[this.edge[i][0]].getCell()[2][0] + this.vertex[this.edge[i][1]].getCell()[2][0]) >> 1;
            ++i;
        }
        return this;
    }

    public Mesh setWireframe(Mesh aMesh) {
        this.screenX = aMesh.screenX;
        this.screenY = aMesh.screenY;
        this.focal = aMesh.focal;
        this.scrX = aMesh.scrX;
        this.scrY = aMesh.scrY;
        this.lines = aMesh.lines;
        return this;
    }

    public int selectVertex(int x, int y, int r) {
        int i = -1;
        int xmr = x - r;
        int xpr = x + r;
        int ymr = y - r;
        int ypr = y + r;
        i = 0;
        while (i < this.nVertex) {
            if (this.scrX[i] >= xmr && this.scrX[i] <= xpr && this.scrY[i] >= ymr && this.scrY[i] <= ypr) break;
            ++i;
        }
        if (i == this.nVertex) {
            i = -1;
        }
        return i;
    }

    public Matrix calculateBounds() {
        Matrix mxXyYzZ = new Matrix(3, 2);
        int j = 0;
        while (j < 3) {
            mxXyYzZ.getCell()[j][0] = 2.147483647E9;
            mxXyYzZ.getCell()[j][1] = -2.147483648E9;
            ++j;
        }
        int i = 0;
        while (i < this.nVertex) {
            int j2 = 0;
            while (j2 < 3) {
                mxXyYzZ.getCell()[j2][0] = Math.min(mxXyYzZ.getCell()[j2][0], this.vertex[i].getCell()[j2][0]);
                mxXyYzZ.getCell()[j2][1] = Math.max(mxXyYzZ.getCell()[j2][1], this.vertex[i].getCell()[j2][0]);
                ++j2;
            }
            ++i;
        }
        return mxXyYzZ;
    }
}

