/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.math.Matrix;

public class Matrix3D
extends Matrix {
    public static Matrix3D MatrixAsMatrix3D(Matrix aMatrix) {
        return new Matrix3D(aMatrix.getCell());
    }

    public Matrix3D() {
        super(4, 4);
        this.toId();
    }

    public Matrix3D(double[][] cell) {
        this.nLines = 4;
        this.nCols = 4;
        this.cell = cell;
    }

    public static Matrix3D translation(double x, double y, double z) {
        Matrix3D result = new Matrix3D();
        result.cell[0][3] = x;
        result.cell[1][3] = y;
        result.cell[2][3] = z;
        return result;
    }

    public static Matrix3D scale(double x, double y, double z) {
        Matrix3D result = new Matrix3D();
        result.cell[0][0] = x;
        result.cell[1][1] = y;
        result.cell[2][2] = z;
        return result;
    }

    public static Matrix3D rotationX(double teta) {
        Matrix3D result = new Matrix3D();
        result.cell[1][1] = Math.cos(teta);
        result.cell[1][2] = Math.sin(teta);
        result.cell[2][1] = -Math.sin(teta);
        result.cell[2][2] = Math.cos(teta);
        return result;
    }

    public static Matrix3D rotationY(double teta) {
        Matrix3D result = new Matrix3D();
        result.cell[0][0] = Math.cos(teta);
        result.cell[0][2] = -Math.sin(teta);
        result.cell[2][0] = Math.sin(teta);
        result.cell[2][2] = Math.cos(teta);
        return result;
    }

    public static Matrix3D rotationZ(double teta) {
        Matrix3D result = new Matrix3D();
        result.cell[0][0] = Math.cos(teta);
        result.cell[0][1] = Math.sin(teta);
        result.cell[1][0] = -Math.sin(teta);
        result.cell[1][1] = Math.cos(teta);
        return result;
    }
}

