/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import org.yriarte.mini3D.Mesh;
import org.yriarte.mini3D.Object3D;
import org.yriarte.mini3D.Vector3D;

public class Grid
extends Object3D {
    public static int DRAW_DEFAULT = 0;
    double unit;
    int steps;

    public Grid(double u, int n) {
        this.unit = u;
        this.steps = n;
        Vector3D[] v = new Vector3D[n * 4 + 1];
        int[][] e = new int[n * 2 + 2][2];
        int i = 0;
        while (i < n) {
            v[i] = new Vector3D((double)i * this.unit, 0.0, 0.0);
            v[i + n] = new Vector3D((double)i * this.unit, 0.0, (double)n * this.unit);
            e[i][0] = i;
            e[i][1] = i + n;
            v[i + 2 * n] = new Vector3D(0.0, 0.0, (double)i * this.unit);
            v[i + 3 * n] = new Vector3D((double)n * this.unit, 0.0, (double)i * this.unit);
            e[i + n][0] = i + 2 * n;
            e[i + n][1] = i + 3 * n;
            ++i;
        }
        v[n * 4] = new Vector3D((double)n * this.unit, 0.0, (double)n * this.unit);
        e[2 * n][0] = 3 * n;
        e[2 * n][1] = 4 * n;
        e[2 * n + 1][0] = n;
        e[2 * n + 1][1] = 4 * n;
        this.mesh = new Mesh(n * 4 + 1, n * 2 + 2, v, e);
    }
}

