/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import java.awt.Graphics;
import java.awt.Image;
import org.yriarte.mini3D.Object3D;

public class Buffered3DGraphics {
    private int width;
    private int height;
    private int focal;
    private int drawMode = Object3D.DRAW_DEFAULT;
    private Object3D model;
    private Image bufferedImage;

    public Buffered3DGraphics(Object3D o, Image i, int w, int h, int f) {
        this.model = o;
        this.width = w;
        this.height = h;
        this.focal = f;
        this.bufferedImage = i;
    }

    public void updateModel() {
        this.model.setDrawMode(this.drawMode);
        this.model.update(this.focal, this.width, this.height);
        this.bufferedImage.getGraphics().clearRect(0, 0, this.width, this.height);
        this.model.paint(this.bufferedImage.getGraphics());
    }

    public void updateView(Graphics g) {
        g.drawImage(this.bufferedImage, 0, 0, null);
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(int drawMode) {
        this.drawMode = drawMode;
    }

    public int getFocal() {
        return this.focal;
    }

    public void setFocal(int focal) {
        this.focal = focal;
    }

    public Object3D getModel() {
        return this.model;
    }

    public void setModel(Object3D model) {
        this.model = model;
    }
}

