/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.mini3D;

import java.util.Observable;
import org.yriarte.math.Matrix;
import org.yriarte.mini3D.Buffered3DGraphics;
import org.yriarte.mini3D.Matrix3D;
import org.yriarte.mini3D.Object3D;

public class Animation
extends Observable
implements Runnable {
    private int nObjects;
    private int millisec;
    private Object3D[] object;
    private TransformList[] trans;
    private Buffered3DGraphics objectGraphics;

    private void init(Buffered3DGraphics g, int n, Object3D[] o, TransformList[] tr, int ms) {
        this.objectGraphics = g;
        this.nObjects = n;
        this.object = o;
        this.trans = tr;
        this.millisec = ms;
    }

    public Animation() {
    }

    public Animation(Buffered3DGraphics g, Object3D obj, int ms) {
        Object3D[] o = new Object3D[]{obj};
        TransformList[] tr = new TransformList[]{null};
        this.init(g, 1, o, tr, ms);
    }

    public Animation merge(Animation a) {
        double fms = this.millisec / a.millisec;
        int n = a.nObjects + this.nObjects;
        Object3D[] obj = new Object3D[n];
        TransformList[] trl = new TransformList[n];
        int i = 0;
        while (i < this.nObjects) {
            obj[i] = this.object[i];
            trl[i] = this.trans[i];
            ++i;
        }
        i = this.nObjects;
        while (i < n) {
            obj[i] = a.object[this.nObjects - i];
            trl[i] = a.trans[this.nObjects - i];
            TransformList transformList = trl[i];
            transformList.nStep = (int)((double)transformList.nStep * fms);
            ++i;
        }
        this.init(this.objectGraphics, n, obj, trl, this.millisec);
        return this;
    }

    public Animation setObjectLoop(Object3D obj, boolean loop) {
        int i = 0;
        while (i < this.nObjects) {
            if (this.object[i] != obj) continue;
            TransformList currTrl = this.trans[i];
            if (currTrl == null) break;
            while (currTrl.next != null && currTrl.next != this.trans[i]) {
                currTrl = currTrl.next;
            }
            currTrl.next = loop ? this.trans[i] : null;
            break;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public Animation addObjectTransformation(Object3D obj, Matrix transform, int nStep) {
        i = 0;
        while (i < this.nObjects) {
            if (this.object[i] != obj) continue;
            newTrl = new TransformList(transform, nStep);
            currTrl = this.trans[i];
            if (currTrl != null) ** GOTO lbl10
            this.trans[i] = newTrl;
            break;
lbl-1000:
            // 1 sources

            {
                currTrl = TransformList.access$2(currTrl);
lbl10:
                // 2 sources

                ** while (TransformList.access$2((TransformList)currTrl) != null && TransformList.access$2((TransformList)currTrl) != this.trans[i])
            }
lbl11:
            // 1 sources

            if (TransformList.access$2(currTrl) == this.trans[i]) {
                TransformList.access$3(newTrl, this.trans[i]);
            }
            TransformList.access$3(currTrl, newTrl);
            break;
        }
        return this;
    }

    public void run() {
        boolean changed = true;
        while (changed && this.nObjects != 0) {
            changed = false;
            int i = 0;
            while (i < this.nObjects) {
                if (this.trans[i] != null) {
                    changed = true;
                    this.object[i].transform(this.trans[i].transform);
                    this.trans[i] = this.trans[i].next();
                }
                ++i;
            }
            if (changed) {
                this.objectGraphics.updateModel();
                this.setChanged();
                this.notifyObservers(this.objectGraphics);
            }
            try {
                Thread.sleep(this.millisec);
            }
            catch (Exception e) {
                System.out.println("Animation exception " + e.toString());
            }
        }
    }

    private class TransformList {
        private TransformList next;
        private Matrix transform;
        private int nStep;
        private int current;

        public TransformList() {
            this.next = null;
            this.transform = new Matrix3D();
            this.current = -1;
            this.nStep = -1;
        }

        public TransformList(Matrix transform, int nStep) {
            this.next = null;
            this.transform = transform;
            this.nStep = this.current = nStep - 1;
        }

        public TransformList(Matrix transform, int nStep, TransformList next) {
            this.next = next;
            this.transform = transform;
            this.nStep = this.current = nStep - 1;
        }

        public TransformList next() {
            if (this.current < 0) {
                return this;
            }
            if (this.current == 0) {
                this.current = this.nStep;
                return this.next;
            }
            --this.current;
            return this;
        }
    }
}

