/*
 * Decompiled with CFR 0.152.
 */
package org.yriarte.math;

import org.yriarte.math.Matrix;

public class Vector
extends Matrix {
    public static Vector MatrixAsVector(Matrix aMatrix) {
        return new Vector(aMatrix.nLines, aMatrix.cell);
    }

    public Vector() {
    }

    public Vector(int lines) {
        super(lines, 1);
    }

    public Vector(int lines, double[][] cell) {
        super(lines, 1, cell);
    }

    public Vector(Matrix aMatrix) {
        super(aMatrix.nLines, 1);
        int i = 0;
        while (i < this.nLines) {
            this.cell[i][0] = aMatrix.cell[i][0];
            ++i;
        }
    }

    public Vector(Matrix aMatrix, int column) {
        super(aMatrix.nLines, 1);
        int i = 0;
        while (i < this.nLines) {
            this.cell[i][0] = aMatrix.cell[i][column];
            ++i;
        }
    }

    public double norm() {
        double n = 0.0;
        int i = 0;
        while (i < this.nLines) {
            n += this.cell[i][0] * this.cell[i][0];
            ++i;
        }
        n = Math.sqrt(n);
        return n;
    }

    public double scalProd(Vector aVector) {
        double result = 0.0;
        int i = 0;
        while (i < this.nLines) {
            result += this.cell[i][0] * aVector.cell[i][0];
            ++i;
        }
        return result;
    }

    public Vector unitVector() {
        double n = this.norm();
        Vector vResult = new Vector(this.nLines);
        if (n != 0.0) {
            int i = 0;
            while (i < this.nLines) {
                vResult.cell[i][0] = this.cell[i][0] / n;
                ++i;
            }
        }
        return vResult;
    }

    public double vectAngle(Vector aVector) {
        double prodScalar = this.scalProd(aVector);
        double prodNorm = this.norm() * aVector.norm();
        return Math.acos(prodScalar / prodNorm);
    }

    public Vector vectProd(Vector aVector) {
        Vector vResult = new Vector(aVector.nLines);
        int i = 0;
        while (i < this.nLines) {
            int ia = (i + 1) % this.nLines;
            int ib = (ia + 1) % this.nLines;
            vResult.cell[i][0] = this.cell[ia][0] * aVector.cell[ib][0] - this.cell[ib][0] * aVector.cell[ia][0];
            ++i;
        }
        return vResult;
    }

    public Vector vectDiv(Vector aVector) {
        Vector vResult = new Vector();
        if (this.isZero()) {
            if (aVector.isZero()) {
                return vResult;
            }
            return null;
        }
        double norma = this.norm();
        vResult = aVector.vectProd(this);
        vResult = new Vector(vResult.mulNum(1.0 / (norma * norma)));
        return vResult;
    }
}

